/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLambdaFunctionRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetLambdaFunctionRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetLambdaFunctionRecommendationsResponse.getter(GetLambdaFunctionRecommendationsResponse::nextToken)).setter(GetLambdaFunctionRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<LambdaFunctionRecommendation>> LAMBDA_FUNCTION_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lambdaFunctionRecommendations").getter(GetLambdaFunctionRecommendationsResponse.getter(GetLambdaFunctionRecommendationsResponse::lambdaFunctionRecommendations)).setter(GetLambdaFunctionRecommendationsResponse.setter(Builder::lambdaFunctionRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaFunctionRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LAMBDA_FUNCTION_RECOMMENDATIONS_FIELD));
    private final String nextToken;
    private final List<LambdaFunctionRecommendation> lambdaFunctionRecommendations;

    private GetLambdaFunctionRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.lambdaFunctionRecommendations = builder.lambdaFunctionRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasLambdaFunctionRecommendations() {
        return this.lambdaFunctionRecommendations != null && !(this.lambdaFunctionRecommendations instanceof SdkAutoConstructList);
    }

    public final List<LambdaFunctionRecommendation> lambdaFunctionRecommendations() {
        return this.lambdaFunctionRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLambdaFunctionRecommendations() ? this.lambdaFunctionRecommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLambdaFunctionRecommendationsResponse)) {
            return false;
        }
        GetLambdaFunctionRecommendationsResponse other = (GetLambdaFunctionRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasLambdaFunctionRecommendations() == other.hasLambdaFunctionRecommendations() && Objects.equals(this.lambdaFunctionRecommendations(), other.lambdaFunctionRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"GetLambdaFunctionRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("LambdaFunctionRecommendations", this.hasLambdaFunctionRecommendations() ? this.lambdaFunctionRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "lambdaFunctionRecommendations": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLambdaFunctionRecommendationsResponse, T> g) {
        return obj -> g.apply((GetLambdaFunctionRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LambdaFunctionRecommendation> lambdaFunctionRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLambdaFunctionRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.lambdaFunctionRecommendations(model.lambdaFunctionRecommendations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<LambdaFunctionRecommendation.Builder> getLambdaFunctionRecommendations() {
            if (this.lambdaFunctionRecommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lambdaFunctionRecommendations != null ? (Collection)this.lambdaFunctionRecommendations.stream().map(LambdaFunctionRecommendation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaFunctionRecommendations(Collection<LambdaFunctionRecommendation> lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations = LambdaFunctionRecommendationsCopier.copy(lambdaFunctionRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRecommendations(LambdaFunctionRecommendation ... lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations(Arrays.asList(lambdaFunctionRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRecommendations(Consumer<LambdaFunctionRecommendation.Builder> ... lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations(Stream.of(lambdaFunctionRecommendations).map(c -> (LambdaFunctionRecommendation)((LambdaFunctionRecommendation.Builder)LambdaFunctionRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLambdaFunctionRecommendations(Collection<LambdaFunctionRecommendation.BuilderImpl> lambdaFunctionRecommendations) {
            this.lambdaFunctionRecommendations = LambdaFunctionRecommendationsCopier.copyFromBuilder(lambdaFunctionRecommendations);
        }

        @Override
        public GetLambdaFunctionRecommendationsResponse build() {
            return new GetLambdaFunctionRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLambdaFunctionRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder lambdaFunctionRecommendations(Collection<LambdaFunctionRecommendation> var1);

        public Builder lambdaFunctionRecommendations(LambdaFunctionRecommendation ... var1);

        public Builder lambdaFunctionRecommendations(Consumer<LambdaFunctionRecommendation.Builder> ... var1);
    }
}

