/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnrollmentStatusResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEnrollmentStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::statusAsString)).setter(GetEnrollmentStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::statusReason)).setter(GetEnrollmentStatusResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Boolean> MEMBER_ACCOUNTS_ENROLLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetEnrollmentStatusResponse.getter(GetEnrollmentStatusResponse::memberAccountsEnrolled)).setter(GetEnrollmentStatusResponse.setter(Builder::memberAccountsEnrolled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountsEnrolled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, MEMBER_ACCOUNTS_ENROLLED_FIELD));
    private final String status;
    private final String statusReason;
    private final Boolean memberAccountsEnrolled;

    private GetEnrollmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.memberAccountsEnrolled = builder.memberAccountsEnrolled;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Boolean memberAccountsEnrolled() {
        return this.memberAccountsEnrolled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountsEnrolled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentStatusResponse)) {
            return false;
        }
        GetEnrollmentStatusResponse other = (GetEnrollmentStatusResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.memberAccountsEnrolled(), other.memberAccountsEnrolled());
    }

    public String toString() {
        return ToString.builder((String)"GetEnrollmentStatusResponse").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("MemberAccountsEnrolled", (Object)this.memberAccountsEnrolled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "memberAccountsEnrolled": {
                return Optional.ofNullable(clazz.cast(this.memberAccountsEnrolled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentStatusResponse, T> g) {
        return obj -> g.apply((GetEnrollmentStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private Boolean memberAccountsEnrolled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentStatusResponse model) {
            super(model);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.memberAccountsEnrolled(model.memberAccountsEnrolled);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Boolean getMemberAccountsEnrolled() {
            return this.memberAccountsEnrolled;
        }

        @Override
        public final Builder memberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
            return this;
        }

        public final void setMemberAccountsEnrolled(Boolean memberAccountsEnrolled) {
            this.memberAccountsEnrolled = memberAccountsEnrolled;
        }

        @Override
        public GetEnrollmentStatusResponse build() {
            return new GetEnrollmentStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnrollmentStatusResponse> {
        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusReason(String var1);

        public Builder memberAccountsEnrolled(Boolean var1);
    }
}

