/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.StringListCopier;
import software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectSyntaxRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, BatchDetectSyntaxRequest> {
    private static final SdkField<List<String>> TEXT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectSyntaxRequest.getter(BatchDetectSyntaxRequest::textList)).setter(BatchDetectSyntaxRequest.setter(Builder::textList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchDetectSyntaxRequest.getter(BatchDetectSyntaxRequest::languageCodeAsString)).setter(BatchDetectSyntaxRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_LIST_FIELD, LANGUAGE_CODE_FIELD));
    private final List<String> textList;
    private final String languageCode;

    private BatchDetectSyntaxRequest(BuilderImpl builder) {
        super(builder);
        this.textList = builder.textList;
        this.languageCode = builder.languageCode;
    }

    public List<String> textList() {
        return this.textList;
    }

    public SyntaxLanguageCode languageCode() {
        return SyntaxLanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.textList());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSyntaxRequest)) {
            return false;
        }
        BatchDetectSyntaxRequest other = (BatchDetectSyntaxRequest)((Object)obj);
        return Objects.equals(this.textList(), other.textList()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectSyntaxRequest").add("TextList", this.textList()).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextList": {
                return Optional.ofNullable(clazz.cast(this.textList()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSyntaxRequest, T> g) {
        return obj -> g.apply((BatchDetectSyntaxRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private List<String> textList = DefaultSdkAutoConstructList.getInstance();
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSyntaxRequest model) {
            super(model);
            this.textList(model.textList);
            this.languageCode(model.languageCode);
        }

        public final Collection<String> getTextList() {
            return this.textList;
        }

        @Override
        public final Builder textList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(String ... textList) {
            this.textList(Arrays.asList(textList));
            return this;
        }

        public final void setTextList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
        }

        public final String getLanguageCodeAsString() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(SyntaxLanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDetectSyntaxRequest build() {
            return new BatchDetectSyntaxRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDetectSyntaxRequest> {
        public Builder textList(Collection<String> var1);

        public Builder textList(String ... var1);

        public Builder languageCode(String var1);

        public Builder languageCode(SyntaxLanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

