/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Toxicity analysis result for one string. For more information about toxicity detection, see <a
 * href="https://docs.aws.amazon.com/comprehend/latest/dg/toxicity-detection.html">Toxicity detection</a> in the
 * <i>Amazon Comprehend Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToxicLabels implements SdkPojo, Serializable, ToCopyableBuilder<ToxicLabels.Builder, ToxicLabels> {
    private static final SdkField<List<ToxicContent>> LABELS_FIELD = SdkField
            .<List<ToxicContent>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(ToxicLabels::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToxicContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToxicContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> TOXICITY_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Toxicity")
            .getter(getter(ToxicLabels::toxicity)).setter(setter(Builder::toxicity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Toxicity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, TOXICITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ToxicContent> labels;

    private final Float toxicity;

    private ToxicLabels(BuilderImpl builder) {
        this.labels = builder.labels;
        this.toxicity = builder.toxicity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of toxic content types identified in the string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return Array of toxic content types identified in the string.
     */
    public final List<ToxicContent> labels() {
        return labels;
    }

    /**
     * <p>
     * Overall toxicity score for the string. Value range is zero to one, where one is the highest confidence.
     * </p>
     * 
     * @return Overall toxicity score for the string. Value range is zero to one, where one is the highest confidence.
     */
    public final Float toxicity() {
        return toxicity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toxicity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicLabels)) {
            return false;
        }
        ToxicLabels other = (ToxicLabels) obj;
        return hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(toxicity(), other.toxicity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToxicLabels").add("Labels", hasLabels() ? labels() : null).add("Toxicity", toxicity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "Toxicity":
            return Optional.ofNullable(clazz.cast(toxicity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Labels", LABELS_FIELD);
        map.put("Toxicity", TOXICITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToxicLabels, T> g) {
        return obj -> g.apply((ToxicLabels) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToxicLabels> {
        /**
         * <p>
         * Array of toxic content types identified in the string.
         * </p>
         * 
         * @param labels
         *        Array of toxic content types identified in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<ToxicContent> labels);

        /**
         * <p>
         * Array of toxic content types identified in the string.
         * </p>
         * 
         * @param labels
         *        Array of toxic content types identified in the string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(ToxicContent... labels);

        /**
         * <p>
         * Array of toxic content types identified in the string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.ToxicContent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.comprehend.model.ToxicContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.ToxicContent.Builder#build()} is called immediately
         * and its result is passed to {@link #labels(List<ToxicContent>)}.
         * 
         * @param labels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.ToxicContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labels(java.util.Collection<ToxicContent>)
         */
        Builder labels(Consumer<ToxicContent.Builder>... labels);

        /**
         * <p>
         * Overall toxicity score for the string. Value range is zero to one, where one is the highest confidence.
         * </p>
         * 
         * @param toxicity
         *        Overall toxicity score for the string. Value range is zero to one, where one is the highest
         *        confidence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toxicity(Float toxicity);
    }

    static final class BuilderImpl implements Builder {
        private List<ToxicContent> labels = DefaultSdkAutoConstructList.getInstance();

        private Float toxicity;

        private BuilderImpl() {
        }

        private BuilderImpl(ToxicLabels model) {
            labels(model.labels);
            toxicity(model.toxicity);
        }

        public final List<ToxicContent.Builder> getLabels() {
            List<ToxicContent.Builder> result = ListOfToxicContentCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<ToxicContent.BuilderImpl> labels) {
            this.labels = ListOfToxicContentCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<ToxicContent> labels) {
            this.labels = ListOfToxicContentCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(ToxicContent... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<ToxicContent.Builder>... labels) {
            labels(Stream.of(labels).map(c -> ToxicContent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getToxicity() {
            return toxicity;
        }

        public final void setToxicity(Float toxicity) {
            this.toxicity = toxicity;
        }

        @Override
        public final Builder toxicity(Float toxicity) {
            this.toxicity = toxicity;
            return this;
        }

        @Override
        public ToxicLabels build() {
            return new ToxicLabels(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
