/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFlywheelIterationResponse extends ComprehendResponse implements
        ToCopyableBuilder<StartFlywheelIterationResponse.Builder, StartFlywheelIterationResponse> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(StartFlywheelIterationResponse::flywheelArn))
            .setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final SdkField<String> FLYWHEEL_ITERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelIterationId").getter(getter(StartFlywheelIterationResponse::flywheelIterationId))
            .setter(setter(Builder::flywheelIterationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelIterationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD,
            FLYWHEEL_ITERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flywheelArn;

    private final String flywheelIterationId;

    private StartFlywheelIterationResponse(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
        this.flywheelIterationId = builder.flywheelIterationId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String flywheelIterationId() {
        return flywheelIterationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(flywheelIterationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlywheelIterationResponse)) {
            return false;
        }
        StartFlywheelIterationResponse other = (StartFlywheelIterationResponse) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn())
                && Objects.equals(flywheelIterationId(), other.flywheelIterationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFlywheelIterationResponse").add("FlywheelArn", flywheelArn())
                .add("FlywheelIterationId", flywheelIterationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        case "FlywheelIterationId":
            return Optional.ofNullable(clazz.cast(flywheelIterationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("FlywheelIterationId", FLYWHEEL_ITERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFlywheelIterationResponse, T> g) {
        return obj -> g.apply((StartFlywheelIterationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartFlywheelIterationResponse> {
        /**
         * <p/>
         * 
         * @param flywheelArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        /**
         * <p/>
         * 
         * @param flywheelIterationId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelIterationId(String flywheelIterationId);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String flywheelArn;

        private String flywheelIterationId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlywheelIterationResponse model) {
            super(model);
            flywheelArn(model.flywheelArn);
            flywheelIterationId(model.flywheelIterationId);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getFlywheelIterationId() {
            return flywheelIterationId;
        }

        public final void setFlywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
        }

        @Override
        public final Builder flywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
            return this;
        }

        @Override
        public StartFlywheelIterationResponse build() {
            return new StartFlywheelIterationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
