/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the part of speech represented by the token and gives the confidence that Amazon Comprehend has that the
 * part of speech was correctly identified. For more information about the parts of speech that Amazon Comprehend can
 * identify, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-syntax.html">Syntax</a> in the Comprehend
 * Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartOfSpeechTag implements SdkPojo, Serializable, ToCopyableBuilder<PartOfSpeechTag.Builder, PartOfSpeechTag> {
    private static final SdkField<String> TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tag")
            .getter(getter(PartOfSpeechTag::tagAsString)).setter(setter(Builder::tag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()).build();

    private static final SdkField<Float> SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Score")
            .getter(getter(PartOfSpeechTag::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FIELD, SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tag;

    private final Float score;

    private PartOfSpeechTag(BuilderImpl builder) {
        this.tag = builder.tag;
        this.score = builder.score;
    }

    /**
     * <p>
     * Identifies the part of speech that the token represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tag} will return
     * {@link PartOfSpeechTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tagAsString}.
     * </p>
     * 
     * @return Identifies the part of speech that the token represents.
     * @see PartOfSpeechTagType
     */
    public final PartOfSpeechTagType tag() {
        return PartOfSpeechTagType.fromValue(tag);
    }

    /**
     * <p>
     * Identifies the part of speech that the token represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tag} will return
     * {@link PartOfSpeechTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tagAsString}.
     * </p>
     * 
     * @return Identifies the part of speech that the token represents.
     * @see PartOfSpeechTagType
     */
    public final String tagAsString() {
        return tag;
    }

    /**
     * <p>
     * The confidence that Amazon Comprehend has that the part of speech was correctly identified.
     * </p>
     * 
     * @return The confidence that Amazon Comprehend has that the part of speech was correctly identified.
     */
    public final Float score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartOfSpeechTag)) {
            return false;
        }
        PartOfSpeechTag other = (PartOfSpeechTag) obj;
        return Objects.equals(tagAsString(), other.tagAsString()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartOfSpeechTag").add("Tag", tagAsString()).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tag":
            return Optional.ofNullable(clazz.cast(tagAsString()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Tag", TAG_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PartOfSpeechTag, T> g) {
        return obj -> g.apply((PartOfSpeechTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartOfSpeechTag> {
        /**
         * <p>
         * Identifies the part of speech that the token represents.
         * </p>
         * 
         * @param tag
         *        Identifies the part of speech that the token represents.
         * @see PartOfSpeechTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartOfSpeechTagType
         */
        Builder tag(String tag);

        /**
         * <p>
         * Identifies the part of speech that the token represents.
         * </p>
         * 
         * @param tag
         *        Identifies the part of speech that the token represents.
         * @see PartOfSpeechTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartOfSpeechTagType
         */
        Builder tag(PartOfSpeechTagType tag);

        /**
         * <p>
         * The confidence that Amazon Comprehend has that the part of speech was correctly identified.
         * </p>
         * 
         * @param score
         *        The confidence that Amazon Comprehend has that the part of speech was correctly identified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Float score);
    }

    static final class BuilderImpl implements Builder {
        private String tag;

        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(PartOfSpeechTag model) {
            tag(model.tag);
            score(model.score);
        }

        public final String getTag() {
            return tag;
        }

        public final void setTag(String tag) {
            this.tag = tag;
        }

        @Override
        public final Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public final Builder tag(PartOfSpeechTagType tag) {
            this.tag(tag == null ? null : tag.toString());
            return this;
        }

        public final Float getScore() {
            return score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        @Override
        public PartOfSpeechTag build() {
            return new PartOfSpeechTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
