/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result metrics for the test data associated with an documentation classifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClassifierEvaluationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<ClassifierEvaluationMetrics.Builder, ClassifierEvaluationMetrics> {
    private static final SdkField<Double> ACCURACY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Accuracy").getter(getter(ClassifierEvaluationMetrics::accuracy)).setter(setter(Builder::accuracy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()).build();

    private static final SdkField<Double> PRECISION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Precision").getter(getter(ClassifierEvaluationMetrics::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()).build();

    private static final SdkField<Double> RECALL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Recall")
            .getter(getter(ClassifierEvaluationMetrics::recall)).setter(setter(Builder::recall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()).build();

    private static final SdkField<Double> F1_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("F1Score").getter(getter(ClassifierEvaluationMetrics::f1Score)).setter(setter(Builder::f1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()).build();

    private static final SdkField<Double> MICRO_PRECISION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MicroPrecision").getter(getter(ClassifierEvaluationMetrics::microPrecision))
            .setter(setter(Builder::microPrecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroPrecision").build()).build();

    private static final SdkField<Double> MICRO_RECALL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MicroRecall").getter(getter(ClassifierEvaluationMetrics::microRecall))
            .setter(setter(Builder::microRecall))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroRecall").build()).build();

    private static final SdkField<Double> MICRO_F1_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MicroF1Score").getter(getter(ClassifierEvaluationMetrics::microF1Score))
            .setter(setter(Builder::microF1Score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroF1Score").build()).build();

    private static final SdkField<Double> HAMMING_LOSS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("HammingLoss").getter(getter(ClassifierEvaluationMetrics::hammingLoss))
            .setter(setter(Builder::hammingLoss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HammingLoss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCURACY_FIELD,
            PRECISION_FIELD, RECALL_FIELD, F1_SCORE_FIELD, MICRO_PRECISION_FIELD, MICRO_RECALL_FIELD, MICRO_F1_SCORE_FIELD,
            HAMMING_LOSS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double accuracy;

    private final Double precision;

    private final Double recall;

    private final Double f1Score;

    private final Double microPrecision;

    private final Double microRecall;

    private final Double microF1Score;

    private final Double hammingLoss;

    private ClassifierEvaluationMetrics(BuilderImpl builder) {
        this.accuracy = builder.accuracy;
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1Score = builder.f1Score;
        this.microPrecision = builder.microPrecision;
        this.microRecall = builder.microRecall;
        this.microF1Score = builder.microF1Score;
        this.hammingLoss = builder.hammingLoss;
    }

    /**
     * <p>
     * The fraction of the labels that were correct recognized. It is computed by dividing the number of labels in the
     * test documents that were correctly recognized by the total number of labels in the test documents.
     * </p>
     * 
     * @return The fraction of the labels that were correct recognized. It is computed by dividing the number of labels
     *         in the test documents that were correctly recognized by the total number of labels in the test documents.
     */
    public final Double accuracy() {
        return accuracy;
    }

    /**
     * <p>
     * A measure of the usefulness of the classifier results in the test data. High precision means that the classifier
     * returned substantially more relevant results than irrelevant ones.
     * </p>
     * 
     * @return A measure of the usefulness of the classifier results in the test data. High precision means that the
     *         classifier returned substantially more relevant results than irrelevant ones.
     */
    public final Double precision() {
        return precision;
    }

    /**
     * <p>
     * A measure of how complete the classifier results are for the test data. High recall means that the classifier
     * returned most of the relevant results.
     * </p>
     * 
     * @return A measure of how complete the classifier results are for the test data. High recall means that the
     *         classifier returned most of the relevant results.
     */
    public final Double recall() {
        return recall;
    }

    /**
     * <p>
     * A measure of how accurate the classifier results are for the test data. It is derived from the
     * <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average of the
     * two scores. The highest score is 1, and the worst score is 0.
     * </p>
     * 
     * @return A measure of how accurate the classifier results are for the test data. It is derived from the
     *         <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average
     *         of the two scores. The highest score is 1, and the worst score is 0.
     */
    public final Double f1Score() {
        return f1Score;
    }

    /**
     * <p>
     * A measure of the usefulness of the recognizer results in the test data. High precision means that the recognizer
     * returned substantially more relevant results than irrelevant ones. Unlike the Precision metric which comes from
     * averaging the precision of all available labels, this is based on the overall score of all precision scores added
     * together.
     * </p>
     * 
     * @return A measure of the usefulness of the recognizer results in the test data. High precision means that the
     *         recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision metric
     *         which comes from averaging the precision of all available labels, this is based on the overall score of
     *         all precision scores added together.
     */
    public final Double microPrecision() {
        return microPrecision;
    }

    /**
     * <p>
     * A measure of how complete the classifier results are for the test data. High recall means that the classifier
     * returned most of the relevant results. Specifically, this indicates how many of the correct categories in the
     * text that the model can predict. It is a percentage of correct categories in the text that can found. Instead of
     * averaging the recall scores of all labels (as with Recall), micro Recall is based on the overall score of all
     * recall scores added together.
     * </p>
     * 
     * @return A measure of how complete the classifier results are for the test data. High recall means that the
     *         classifier returned most of the relevant results. Specifically, this indicates how many of the correct
     *         categories in the text that the model can predict. It is a percentage of correct categories in the text
     *         that can found. Instead of averaging the recall scores of all labels (as with Recall), micro Recall is
     *         based on the overall score of all recall scores added together.
     */
    public final Double microRecall() {
        return microRecall;
    }

    /**
     * <p>
     * A measure of how accurate the classifier results are for the test data. It is a combination of the
     * <code>Micro Precision</code> and <code>Micro Recall</code> values. The <code>Micro F1Score</code> is the harmonic
     * mean of the two scores. The highest score is 1, and the worst score is 0.
     * </p>
     * 
     * @return A measure of how accurate the classifier results are for the test data. It is a combination of the
     *         <code>Micro Precision</code> and <code>Micro Recall</code> values. The <code>Micro F1Score</code> is the
     *         harmonic mean of the two scores. The highest score is 1, and the worst score is 0.
     */
    public final Double microF1Score() {
        return microF1Score;
    }

    /**
     * <p>
     * Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong labels
     * compared to the total number of labels. Scores closer to zero are better.
     * </p>
     * 
     * @return Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong
     *         labels compared to the total number of labels. Scores closer to zero are better.
     */
    public final Double hammingLoss() {
        return hammingLoss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(recall());
        hashCode = 31 * hashCode + Objects.hashCode(f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(microPrecision());
        hashCode = 31 * hashCode + Objects.hashCode(microRecall());
        hashCode = 31 * hashCode + Objects.hashCode(microF1Score());
        hashCode = 31 * hashCode + Objects.hashCode(hammingLoss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierEvaluationMetrics)) {
            return false;
        }
        ClassifierEvaluationMetrics other = (ClassifierEvaluationMetrics) obj;
        return Objects.equals(accuracy(), other.accuracy()) && Objects.equals(precision(), other.precision())
                && Objects.equals(recall(), other.recall()) && Objects.equals(f1Score(), other.f1Score())
                && Objects.equals(microPrecision(), other.microPrecision()) && Objects.equals(microRecall(), other.microRecall())
                && Objects.equals(microF1Score(), other.microF1Score()) && Objects.equals(hammingLoss(), other.hammingLoss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClassifierEvaluationMetrics").add("Accuracy", accuracy()).add("Precision", precision())
                .add("Recall", recall()).add("F1Score", f1Score()).add("MicroPrecision", microPrecision())
                .add("MicroRecall", microRecall()).add("MicroF1Score", microF1Score()).add("HammingLoss", hammingLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accuracy":
            return Optional.ofNullable(clazz.cast(accuracy()));
        case "Precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "Recall":
            return Optional.ofNullable(clazz.cast(recall()));
        case "F1Score":
            return Optional.ofNullable(clazz.cast(f1Score()));
        case "MicroPrecision":
            return Optional.ofNullable(clazz.cast(microPrecision()));
        case "MicroRecall":
            return Optional.ofNullable(clazz.cast(microRecall()));
        case "MicroF1Score":
            return Optional.ofNullable(clazz.cast(microF1Score()));
        case "HammingLoss":
            return Optional.ofNullable(clazz.cast(hammingLoss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accuracy", ACCURACY_FIELD);
        map.put("Precision", PRECISION_FIELD);
        map.put("Recall", RECALL_FIELD);
        map.put("F1Score", F1_SCORE_FIELD);
        map.put("MicroPrecision", MICRO_PRECISION_FIELD);
        map.put("MicroRecall", MICRO_RECALL_FIELD);
        map.put("MicroF1Score", MICRO_F1_SCORE_FIELD);
        map.put("HammingLoss", HAMMING_LOSS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClassifierEvaluationMetrics, T> g) {
        return obj -> g.apply((ClassifierEvaluationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClassifierEvaluationMetrics> {
        /**
         * <p>
         * The fraction of the labels that were correct recognized. It is computed by dividing the number of labels in
         * the test documents that were correctly recognized by the total number of labels in the test documents.
         * </p>
         * 
         * @param accuracy
         *        The fraction of the labels that were correct recognized. It is computed by dividing the number of
         *        labels in the test documents that were correctly recognized by the total number of labels in the test
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accuracy(Double accuracy);

        /**
         * <p>
         * A measure of the usefulness of the classifier results in the test data. High precision means that the
         * classifier returned substantially more relevant results than irrelevant ones.
         * </p>
         * 
         * @param precision
         *        A measure of the usefulness of the classifier results in the test data. High precision means that the
         *        classifier returned substantially more relevant results than irrelevant ones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Double precision);

        /**
         * <p>
         * A measure of how complete the classifier results are for the test data. High recall means that the classifier
         * returned most of the relevant results.
         * </p>
         * 
         * @param recall
         *        A measure of how complete the classifier results are for the test data. High recall means that the
         *        classifier returned most of the relevant results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recall(Double recall);

        /**
         * <p>
         * A measure of how accurate the classifier results are for the test data. It is derived from the
         * <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic average of
         * the two scores. The highest score is 1, and the worst score is 0.
         * </p>
         * 
         * @param f1Score
         *        A measure of how accurate the classifier results are for the test data. It is derived from the
         *        <code>Precision</code> and <code>Recall</code> values. The <code>F1Score</code> is the harmonic
         *        average of the two scores. The highest score is 1, and the worst score is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder f1Score(Double f1Score);

        /**
         * <p>
         * A measure of the usefulness of the recognizer results in the test data. High precision means that the
         * recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision metric
         * which comes from averaging the precision of all available labels, this is based on the overall score of all
         * precision scores added together.
         * </p>
         * 
         * @param microPrecision
         *        A measure of the usefulness of the recognizer results in the test data. High precision means that the
         *        recognizer returned substantially more relevant results than irrelevant ones. Unlike the Precision
         *        metric which comes from averaging the precision of all available labels, this is based on the overall
         *        score of all precision scores added together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microPrecision(Double microPrecision);

        /**
         * <p>
         * A measure of how complete the classifier results are for the test data. High recall means that the classifier
         * returned most of the relevant results. Specifically, this indicates how many of the correct categories in the
         * text that the model can predict. It is a percentage of correct categories in the text that can found. Instead
         * of averaging the recall scores of all labels (as with Recall), micro Recall is based on the overall score of
         * all recall scores added together.
         * </p>
         * 
         * @param microRecall
         *        A measure of how complete the classifier results are for the test data. High recall means that the
         *        classifier returned most of the relevant results. Specifically, this indicates how many of the correct
         *        categories in the text that the model can predict. It is a percentage of correct categories in the
         *        text that can found. Instead of averaging the recall scores of all labels (as with Recall), micro
         *        Recall is based on the overall score of all recall scores added together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microRecall(Double microRecall);

        /**
         * <p>
         * A measure of how accurate the classifier results are for the test data. It is a combination of the
         * <code>Micro Precision</code> and <code>Micro Recall</code> values. The <code>Micro F1Score</code> is the
         * harmonic mean of the two scores. The highest score is 1, and the worst score is 0.
         * </p>
         * 
         * @param microF1Score
         *        A measure of how accurate the classifier results are for the test data. It is a combination of the
         *        <code>Micro Precision</code> and <code>Micro Recall</code> values. The <code>Micro F1Score</code> is
         *        the harmonic mean of the two scores. The highest score is 1, and the worst score is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder microF1Score(Double microF1Score);

        /**
         * <p>
         * Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong labels
         * compared to the total number of labels. Scores closer to zero are better.
         * </p>
         * 
         * @param hammingLoss
         *        Indicates the fraction of labels that are incorrectly predicted. Also seen as the fraction of wrong
         *        labels compared to the total number of labels. Scores closer to zero are better.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hammingLoss(Double hammingLoss);
    }

    static final class BuilderImpl implements Builder {
        private Double accuracy;

        private Double precision;

        private Double recall;

        private Double f1Score;

        private Double microPrecision;

        private Double microRecall;

        private Double microF1Score;

        private Double hammingLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifierEvaluationMetrics model) {
            accuracy(model.accuracy);
            precision(model.precision);
            recall(model.recall);
            f1Score(model.f1Score);
            microPrecision(model.microPrecision);
            microRecall(model.microRecall);
            microF1Score(model.microF1Score);
            hammingLoss(model.hammingLoss);
        }

        public final Double getAccuracy() {
            return accuracy;
        }

        public final void setAccuracy(Double accuracy) {
            this.accuracy = accuracy;
        }

        @Override
        public final Builder accuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final Double getPrecision() {
            return precision;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final Double getRecall() {
            return recall;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        @Override
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final Double getF1Score() {
            return f1Score;
        }

        public final void setF1Score(Double f1Score) {
            this.f1Score = f1Score;
        }

        @Override
        public final Builder f1Score(Double f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final Double getMicroPrecision() {
            return microPrecision;
        }

        public final void setMicroPrecision(Double microPrecision) {
            this.microPrecision = microPrecision;
        }

        @Override
        public final Builder microPrecision(Double microPrecision) {
            this.microPrecision = microPrecision;
            return this;
        }

        public final Double getMicroRecall() {
            return microRecall;
        }

        public final void setMicroRecall(Double microRecall) {
            this.microRecall = microRecall;
        }

        @Override
        public final Builder microRecall(Double microRecall) {
            this.microRecall = microRecall;
            return this;
        }

        public final Double getMicroF1Score() {
            return microF1Score;
        }

        public final void setMicroF1Score(Double microF1Score) {
            this.microF1Score = microF1Score;
        }

        @Override
        public final Builder microF1Score(Double microF1Score) {
            this.microF1Score = microF1Score;
            return this;
        }

        public final Double getHammingLoss() {
            return hammingLoss;
        }

        public final void setHammingLoss(Double hammingLoss) {
            this.hammingLoss = hammingLoss;
        }

        @Override
        public final Builder hammingLoss(Double hammingLoss) {
            this.hammingLoss = hammingLoss;
            return this;
        }

        @Override
        public ClassifierEvaluationMetrics build() {
            return new ClassifierEvaluationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
