/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListCopier;
import software.amazon.awssdk.services.comprehend.model.DatasetAugmentedManifestsListItem;
import software.amazon.awssdk.services.comprehend.model.DatasetDataFormat;
import software.amazon.awssdk.services.comprehend.model.DatasetDocumentClassifierInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerInputDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetInputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetInputDataConfig> {
    private static final SdkField<List<DatasetAugmentedManifestsListItem>> AUGMENTED_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AugmentedManifests").getter(DatasetInputDataConfig.getter(DatasetInputDataConfig::augmentedManifests)).setter(DatasetInputDataConfig.setter(Builder::augmentedManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AugmentedManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetAugmentedManifestsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(DatasetInputDataConfig.getter(DatasetInputDataConfig::dataFormatAsString)).setter(DatasetInputDataConfig.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<DatasetDocumentClassifierInputDataConfig> DOCUMENT_CLASSIFIER_INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentClassifierInputDataConfig").getter(DatasetInputDataConfig.getter(DatasetInputDataConfig::documentClassifierInputDataConfig)).setter(DatasetInputDataConfig.setter(Builder::documentClassifierInputDataConfig)).constructor(DatasetDocumentClassifierInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierInputDataConfig").build()}).build();
    private static final SdkField<DatasetEntityRecognizerInputDataConfig> ENTITY_RECOGNIZER_INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityRecognizerInputDataConfig").getter(DatasetInputDataConfig.getter(DatasetInputDataConfig::entityRecognizerInputDataConfig)).setter(DatasetInputDataConfig.setter(Builder::entityRecognizerInputDataConfig)).constructor(DatasetEntityRecognizerInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerInputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUGMENTED_MANIFESTS_FIELD, DATA_FORMAT_FIELD, DOCUMENT_CLASSIFIER_INPUT_DATA_CONFIG_FIELD, ENTITY_RECOGNIZER_INPUT_DATA_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetInputDataConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DatasetAugmentedManifestsListItem> augmentedManifests;
    private final String dataFormat;
    private final DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig;
    private final DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig;

    private DatasetInputDataConfig(BuilderImpl builder) {
        this.augmentedManifests = builder.augmentedManifests;
        this.dataFormat = builder.dataFormat;
        this.documentClassifierInputDataConfig = builder.documentClassifierInputDataConfig;
        this.entityRecognizerInputDataConfig = builder.entityRecognizerInputDataConfig;
    }

    public final boolean hasAugmentedManifests() {
        return this.augmentedManifests != null && !(this.augmentedManifests instanceof SdkAutoConstructList);
    }

    public final List<DatasetAugmentedManifestsListItem> augmentedManifests() {
        return this.augmentedManifests;
    }

    public final DatasetDataFormat dataFormat() {
        return DatasetDataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig() {
        return this.documentClassifierInputDataConfig;
    }

    public final DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig() {
        return this.entityRecognizerInputDataConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAugmentedManifests() ? this.augmentedManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassifierInputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRecognizerInputDataConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetInputDataConfig)) {
            return false;
        }
        DatasetInputDataConfig other = (DatasetInputDataConfig)obj;
        return this.hasAugmentedManifests() == other.hasAugmentedManifests() && Objects.equals(this.augmentedManifests(), other.augmentedManifests()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.documentClassifierInputDataConfig(), other.documentClassifierInputDataConfig()) && Objects.equals(this.entityRecognizerInputDataConfig(), other.entityRecognizerInputDataConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetInputDataConfig").add("AugmentedManifests", this.hasAugmentedManifests() ? this.augmentedManifests() : null).add("DataFormat", (Object)this.dataFormatAsString()).add("DocumentClassifierInputDataConfig", (Object)this.documentClassifierInputDataConfig()).add("EntityRecognizerInputDataConfig", (Object)this.entityRecognizerInputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AugmentedManifests": {
                return Optional.ofNullable(clazz.cast(this.augmentedManifests()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "DocumentClassifierInputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierInputDataConfig()));
            }
            case "EntityRecognizerInputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.entityRecognizerInputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AugmentedManifests", AUGMENTED_MANIFESTS_FIELD);
        map.put("DataFormat", DATA_FORMAT_FIELD);
        map.put("DocumentClassifierInputDataConfig", DOCUMENT_CLASSIFIER_INPUT_DATA_CONFIG_FIELD);
        map.put("EntityRecognizerInputDataConfig", ENTITY_RECOGNIZER_INPUT_DATA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetInputDataConfig, T> g) {
        return obj -> g.apply((DatasetInputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DatasetAugmentedManifestsListItem> augmentedManifests = DefaultSdkAutoConstructList.getInstance();
        private String dataFormat;
        private DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig;
        private DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetInputDataConfig model) {
            this.augmentedManifests(model.augmentedManifests);
            this.dataFormat(model.dataFormat);
            this.documentClassifierInputDataConfig(model.documentClassifierInputDataConfig);
            this.entityRecognizerInputDataConfig(model.entityRecognizerInputDataConfig);
        }

        public final List<DatasetAugmentedManifestsListItem.Builder> getAugmentedManifests() {
            List<DatasetAugmentedManifestsListItem.Builder> result = DatasetAugmentedManifestsListCopier.copyToBuilder(this.augmentedManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAugmentedManifests(Collection<DatasetAugmentedManifestsListItem.BuilderImpl> augmentedManifests) {
            this.augmentedManifests = DatasetAugmentedManifestsListCopier.copyFromBuilder(augmentedManifests);
        }

        @Override
        public final Builder augmentedManifests(Collection<DatasetAugmentedManifestsListItem> augmentedManifests) {
            this.augmentedManifests = DatasetAugmentedManifestsListCopier.copy(augmentedManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(DatasetAugmentedManifestsListItem ... augmentedManifests) {
            this.augmentedManifests(Arrays.asList(augmentedManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder augmentedManifests(Consumer<DatasetAugmentedManifestsListItem.Builder> ... augmentedManifests) {
            this.augmentedManifests(Stream.of(augmentedManifests).map(c -> (DatasetAugmentedManifestsListItem)((DatasetAugmentedManifestsListItem.Builder)DatasetAugmentedManifestsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DatasetDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final DatasetDocumentClassifierInputDataConfig.Builder getDocumentClassifierInputDataConfig() {
            return this.documentClassifierInputDataConfig != null ? this.documentClassifierInputDataConfig.toBuilder() : null;
        }

        public final void setDocumentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig.BuilderImpl documentClassifierInputDataConfig) {
            this.documentClassifierInputDataConfig = documentClassifierInputDataConfig != null ? documentClassifierInputDataConfig.build() : null;
        }

        @Override
        public final Builder documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig documentClassifierInputDataConfig) {
            this.documentClassifierInputDataConfig = documentClassifierInputDataConfig;
            return this;
        }

        public final DatasetEntityRecognizerInputDataConfig.Builder getEntityRecognizerInputDataConfig() {
            return this.entityRecognizerInputDataConfig != null ? this.entityRecognizerInputDataConfig.toBuilder() : null;
        }

        public final void setEntityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig.BuilderImpl entityRecognizerInputDataConfig) {
            this.entityRecognizerInputDataConfig = entityRecognizerInputDataConfig != null ? entityRecognizerInputDataConfig.build() : null;
        }

        @Override
        public final Builder entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig entityRecognizerInputDataConfig) {
            this.entityRecognizerInputDataConfig = entityRecognizerInputDataConfig;
            return this;
        }

        public DatasetInputDataConfig build() {
            return new DatasetInputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetInputDataConfig> {
        public Builder augmentedManifests(Collection<DatasetAugmentedManifestsListItem> var1);

        public Builder augmentedManifests(DatasetAugmentedManifestsListItem ... var1);

        public Builder augmentedManifests(Consumer<DatasetAugmentedManifestsListItem.Builder> ... var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DatasetDataFormat var1);

        public Builder documentClassifierInputDataConfig(DatasetDocumentClassifierInputDataConfig var1);

        default public Builder documentClassifierInputDataConfig(Consumer<DatasetDocumentClassifierInputDataConfig.Builder> documentClassifierInputDataConfig) {
            return this.documentClassifierInputDataConfig((DatasetDocumentClassifierInputDataConfig)((DatasetDocumentClassifierInputDataConfig.Builder)DatasetDocumentClassifierInputDataConfig.builder().applyMutation(documentClassifierInputDataConfig)).build());
        }

        public Builder entityRecognizerInputDataConfig(DatasetEntityRecognizerInputDataConfig var1);

        default public Builder entityRecognizerInputDataConfig(Consumer<DatasetEntityRecognizerInputDataConfig.Builder> entityRecognizerInputDataConfig) {
            return this.entityRecognizerInputDataConfig((DatasetEntityRecognizerInputDataConfig)((DatasetEntityRecognizerInputDataConfig.Builder)DatasetEntityRecognizerInputDataConfig.builder().applyMutation(entityRecognizerInputDataConfig)).build());
        }
    }
}

