/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ListOfTargetedSentimentEntitiesCopier;
import software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectTargetedSentimentItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectTargetedSentimentItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(BatchDetectTargetedSentimentItemResult.getter(BatchDetectTargetedSentimentItemResult::index)).setter(BatchDetectTargetedSentimentItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<TargetedSentimentEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(BatchDetectTargetedSentimentItemResult.getter(BatchDetectTargetedSentimentItemResult::entities)).setter(BatchDetectTargetedSentimentItemResult.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetedSentimentEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDetectTargetedSentimentItemResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<TargetedSentimentEntity> entities;

    private BatchDetectTargetedSentimentItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.entities = builder.entities;
    }

    public final Integer index() {
        return this.index;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<TargetedSentimentEntity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectTargetedSentimentItemResult)) {
            return false;
        }
        BatchDetectTargetedSentimentItemResult other = (BatchDetectTargetedSentimentItemResult)obj;
        return Objects.equals(this.index(), other.index()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetectTargetedSentimentItemResult").add("Index", (Object)this.index()).add("Entities", this.hasEntities() ? this.entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Index", INDEX_FIELD);
        map.put("Entities", ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectTargetedSentimentItemResult, T> g) {
        return obj -> g.apply((BatchDetectTargetedSentimentItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<TargetedSentimentEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectTargetedSentimentItemResult model) {
            this.index(model.index);
            this.entities(model.entities);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final List<TargetedSentimentEntity.Builder> getEntities() {
            List<TargetedSentimentEntity.Builder> result = ListOfTargetedSentimentEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<TargetedSentimentEntity.BuilderImpl> entities) {
            this.entities = ListOfTargetedSentimentEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<TargetedSentimentEntity> entities) {
            this.entities = ListOfTargetedSentimentEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(TargetedSentimentEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<TargetedSentimentEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (TargetedSentimentEntity)((TargetedSentimentEntity.Builder)TargetedSentimentEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchDetectTargetedSentimentItemResult build() {
            return new BatchDetectTargetedSentimentItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectTargetedSentimentItemResult> {
        public Builder index(Integer var1);

        public Builder entities(Collection<TargetedSentimentEntity> var1);

        public Builder entities(TargetedSentimentEntity ... var1);

        public Builder entities(Consumer<TargetedSentimentEntity.Builder> ... var1);
    }
}

