/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummariesListCopier;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentClassifierSummariesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDocumentClassifierSummariesResponse> {
    private static final SdkField<List<DocumentClassifierSummary>> DOCUMENT_CLASSIFIER_SUMMARIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentClassifierSummariesList").getter(ListDocumentClassifierSummariesResponse.getter(ListDocumentClassifierSummariesResponse::documentClassifierSummariesList)).setter(ListDocumentClassifierSummariesResponse.setter(Builder::documentClassifierSummariesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierSummariesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClassifierSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentClassifierSummariesResponse.getter(ListDocumentClassifierSummariesResponse::nextToken)).setter(ListDocumentClassifierSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFIER_SUMMARIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDocumentClassifierSummariesResponse.memberNameToFieldInitializer();
    private final List<DocumentClassifierSummary> documentClassifierSummariesList;
    private final String nextToken;

    private ListDocumentClassifierSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassifierSummariesList = builder.documentClassifierSummariesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDocumentClassifierSummariesList() {
        return this.documentClassifierSummariesList != null && !(this.documentClassifierSummariesList instanceof SdkAutoConstructList);
    }

    public final List<DocumentClassifierSummary> documentClassifierSummariesList() {
        return this.documentClassifierSummariesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentClassifierSummariesList() ? this.documentClassifierSummariesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassifierSummariesResponse)) {
            return false;
        }
        ListDocumentClassifierSummariesResponse other = (ListDocumentClassifierSummariesResponse)((Object)obj);
        return this.hasDocumentClassifierSummariesList() == other.hasDocumentClassifierSummariesList() && Objects.equals(this.documentClassifierSummariesList(), other.documentClassifierSummariesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentClassifierSummariesResponse").add("DocumentClassifierSummariesList", this.hasDocumentClassifierSummariesList() ? this.documentClassifierSummariesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassifierSummariesList": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierSummariesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentClassifierSummariesList", DOCUMENT_CLASSIFIER_SUMMARIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassifierSummariesResponse, T> g) {
        return obj -> g.apply((ListDocumentClassifierSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClassifierSummary> documentClassifierSummariesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassifierSummariesResponse model) {
            super(model);
            this.documentClassifierSummariesList(model.documentClassifierSummariesList);
            this.nextToken(model.nextToken);
        }

        public final List<DocumentClassifierSummary.Builder> getDocumentClassifierSummariesList() {
            List<DocumentClassifierSummary.Builder> result = DocumentClassifierSummariesListCopier.copyToBuilder(this.documentClassifierSummariesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentClassifierSummariesList(Collection<DocumentClassifierSummary.BuilderImpl> documentClassifierSummariesList) {
            this.documentClassifierSummariesList = DocumentClassifierSummariesListCopier.copyFromBuilder(documentClassifierSummariesList);
        }

        @Override
        public final Builder documentClassifierSummariesList(Collection<DocumentClassifierSummary> documentClassifierSummariesList) {
            this.documentClassifierSummariesList = DocumentClassifierSummariesListCopier.copy(documentClassifierSummariesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierSummariesList(DocumentClassifierSummary ... documentClassifierSummariesList) {
            this.documentClassifierSummariesList(Arrays.asList(documentClassifierSummariesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierSummariesList(Consumer<DocumentClassifierSummary.Builder> ... documentClassifierSummariesList) {
            this.documentClassifierSummariesList(Stream.of(documentClassifierSummariesList).map(c -> (DocumentClassifierSummary)((DocumentClassifierSummary.Builder)DocumentClassifierSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentClassifierSummariesResponse build() {
            return new ListDocumentClassifierSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentClassifierSummariesResponse> {
        public Builder documentClassifierSummariesList(Collection<DocumentClassifierSummary> var1);

        public Builder documentClassifierSummariesList(DocumentClassifierSummary ... var1);

        public Builder documentClassifierSummariesList(Consumer<DocumentClassifierSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

