/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;
import software.amazon.awssdk.services.comprehend.model.ListOfKeyPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectKeyPhrasesItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(BatchDetectKeyPhrasesItemResult.getter(BatchDetectKeyPhrasesItemResult::index)).setter(BatchDetectKeyPhrasesItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPhrases").getter(BatchDetectKeyPhrasesItemResult.getter(BatchDetectKeyPhrasesItemResult::keyPhrases)).setter(BatchDetectKeyPhrasesItemResult.setter(Builder::keyPhrases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPhrase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, KEY_PHRASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDetectKeyPhrasesItemResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<KeyPhrase> keyPhrases;

    private BatchDetectKeyPhrasesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.keyPhrases = builder.keyPhrases;
    }

    public final Integer index() {
        return this.index;
    }

    public final boolean hasKeyPhrases() {
        return this.keyPhrases != null && !(this.keyPhrases instanceof SdkAutoConstructList);
    }

    public final List<KeyPhrase> keyPhrases() {
        return this.keyPhrases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPhrases() ? this.keyPhrases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectKeyPhrasesItemResult)) {
            return false;
        }
        BatchDetectKeyPhrasesItemResult other = (BatchDetectKeyPhrasesItemResult)obj;
        return Objects.equals(this.index(), other.index()) && this.hasKeyPhrases() == other.hasKeyPhrases() && Objects.equals(this.keyPhrases(), other.keyPhrases());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetectKeyPhrasesItemResult").add("Index", (Object)this.index()).add("KeyPhrases", this.hasKeyPhrases() ? this.keyPhrases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "KeyPhrases": {
                return Optional.ofNullable(clazz.cast(this.keyPhrases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Index", INDEX_FIELD);
        map.put("KeyPhrases", KEY_PHRASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectKeyPhrasesItemResult, T> g) {
        return obj -> g.apply((BatchDetectKeyPhrasesItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectKeyPhrasesItemResult model) {
            this.index(model.index);
            this.keyPhrases(model.keyPhrases);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final List<KeyPhrase.Builder> getKeyPhrases() {
            List<KeyPhrase.Builder> result = ListOfKeyPhrasesCopier.copyToBuilder(this.keyPhrases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase ... keyPhrases) {
            this.keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder> ... keyPhrases) {
            this.keyPhrases(Stream.of(keyPhrases).map(c -> (KeyPhrase)((KeyPhrase.Builder)KeyPhrase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchDetectKeyPhrasesItemResult build() {
            return new BatchDetectKeyPhrasesItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
        public Builder index(Integer var1);

        public Builder keyPhrases(Collection<KeyPhrase> var1);

        public Builder keyPhrases(KeyPhrase ... var1);

        public Builder keyPhrases(Consumer<KeyPhrase.Builder> ... var1);
    }
}

