/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerAnnotations;
import software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerDocuments;
import software.amazon.awssdk.services.comprehend.model.DatasetEntityRecognizerEntityList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetEntityRecognizerInputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetEntityRecognizerInputDataConfig> {
    private static final SdkField<DatasetEntityRecognizerAnnotations> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Annotations").getter(DatasetEntityRecognizerInputDataConfig.getter(DatasetEntityRecognizerInputDataConfig::annotations)).setter(DatasetEntityRecognizerInputDataConfig.setter(Builder::annotations)).constructor(DatasetEntityRecognizerAnnotations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build()}).build();
    private static final SdkField<DatasetEntityRecognizerDocuments> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Documents").getter(DatasetEntityRecognizerInputDataConfig.getter(DatasetEntityRecognizerInputDataConfig::documents)).setter(DatasetEntityRecognizerInputDataConfig.setter(Builder::documents)).constructor(DatasetEntityRecognizerDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build()}).build();
    private static final SdkField<DatasetEntityRecognizerEntityList> ENTITY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityList").getter(DatasetEntityRecognizerInputDataConfig.getter(DatasetEntityRecognizerInputDataConfig::entityList)).setter(DatasetEntityRecognizerInputDataConfig.setter(Builder::entityList)).constructor(DatasetEntityRecognizerEntityList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATIONS_FIELD, DOCUMENTS_FIELD, ENTITY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetEntityRecognizerInputDataConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DatasetEntityRecognizerAnnotations annotations;
    private final DatasetEntityRecognizerDocuments documents;
    private final DatasetEntityRecognizerEntityList entityList;

    private DatasetEntityRecognizerInputDataConfig(BuilderImpl builder) {
        this.annotations = builder.annotations;
        this.documents = builder.documents;
        this.entityList = builder.entityList;
    }

    public final DatasetEntityRecognizerAnnotations annotations() {
        return this.annotations;
    }

    public final DatasetEntityRecognizerDocuments documents() {
        return this.documents;
    }

    public final DatasetEntityRecognizerEntityList entityList() {
        return this.entityList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotations());
        hashCode = 31 * hashCode + Objects.hashCode(this.documents());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetEntityRecognizerInputDataConfig)) {
            return false;
        }
        DatasetEntityRecognizerInputDataConfig other = (DatasetEntityRecognizerInputDataConfig)obj;
        return Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.entityList(), other.entityList());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetEntityRecognizerInputDataConfig").add("Annotations", (Object)this.annotations()).add("Documents", (Object)this.documents()).add("EntityList", (Object)this.entityList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "Documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "EntityList": {
                return Optional.ofNullable(clazz.cast(this.entityList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Annotations", ANNOTATIONS_FIELD);
        map.put("Documents", DOCUMENTS_FIELD);
        map.put("EntityList", ENTITY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetEntityRecognizerInputDataConfig, T> g) {
        return obj -> g.apply((DatasetEntityRecognizerInputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DatasetEntityRecognizerAnnotations annotations;
        private DatasetEntityRecognizerDocuments documents;
        private DatasetEntityRecognizerEntityList entityList;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetEntityRecognizerInputDataConfig model) {
            this.annotations(model.annotations);
            this.documents(model.documents);
            this.entityList(model.entityList);
        }

        public final DatasetEntityRecognizerAnnotations.Builder getAnnotations() {
            return this.annotations != null ? this.annotations.toBuilder() : null;
        }

        public final void setAnnotations(DatasetEntityRecognizerAnnotations.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        @Override
        public final Builder annotations(DatasetEntityRecognizerAnnotations annotations) {
            this.annotations = annotations;
            return this;
        }

        public final DatasetEntityRecognizerDocuments.Builder getDocuments() {
            return this.documents != null ? this.documents.toBuilder() : null;
        }

        public final void setDocuments(DatasetEntityRecognizerDocuments.BuilderImpl documents) {
            this.documents = documents != null ? documents.build() : null;
        }

        @Override
        public final Builder documents(DatasetEntityRecognizerDocuments documents) {
            this.documents = documents;
            return this;
        }

        public final DatasetEntityRecognizerEntityList.Builder getEntityList() {
            return this.entityList != null ? this.entityList.toBuilder() : null;
        }

        public final void setEntityList(DatasetEntityRecognizerEntityList.BuilderImpl entityList) {
            this.entityList = entityList != null ? entityList.build() : null;
        }

        @Override
        public final Builder entityList(DatasetEntityRecognizerEntityList entityList) {
            this.entityList = entityList;
            return this;
        }

        public DatasetEntityRecognizerInputDataConfig build() {
            return new DatasetEntityRecognizerInputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetEntityRecognizerInputDataConfig> {
        public Builder annotations(DatasetEntityRecognizerAnnotations var1);

        default public Builder annotations(Consumer<DatasetEntityRecognizerAnnotations.Builder> annotations) {
            return this.annotations((DatasetEntityRecognizerAnnotations)((DatasetEntityRecognizerAnnotations.Builder)DatasetEntityRecognizerAnnotations.builder().applyMutation(annotations)).build());
        }

        public Builder documents(DatasetEntityRecognizerDocuments var1);

        default public Builder documents(Consumer<DatasetEntityRecognizerDocuments.Builder> documents) {
            return this.documents((DatasetEntityRecognizerDocuments)((DatasetEntityRecognizerDocuments.Builder)DatasetEntityRecognizerDocuments.builder().applyMutation(documents)).build());
        }

        public Builder entityList(DatasetEntityRecognizerEntityList var1);

        default public Builder entityList(Consumer<DatasetEntityRecognizerEntityList.Builder> entityList) {
            return this.entityList((DatasetEntityRecognizerEntityList)((DatasetEntityRecognizerEntityList.Builder)DatasetEntityRecognizerEntityList.builder().applyMutation(entityList)).build());
        }
    }
}

