/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.internal.UserAgentUtils;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;

public class ListDocumentClassifiersPublisher
implements SdkPublisher<ListDocumentClassifiersResponse> {
    private final ComprehendAsyncClient client;
    private final ListDocumentClassifiersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDocumentClassifiersPublisher(ComprehendAsyncClient client, ListDocumentClassifiersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDocumentClassifiersPublisher(ComprehendAsyncClient client, ListDocumentClassifiersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDocumentClassifiersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDocumentClassifiersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDocumentClassifiersResponseFetcher
    implements AsyncPageFetcher<ListDocumentClassifiersResponse> {
        private ListDocumentClassifiersResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassifiersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDocumentClassifiersResponse> nextPage(ListDocumentClassifiersResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassifiersPublisher.this.client.listDocumentClassifiers(ListDocumentClassifiersPublisher.this.firstRequest);
            }
            return ListDocumentClassifiersPublisher.this.client.listDocumentClassifiers((ListDocumentClassifiersRequest)((Object)ListDocumentClassifiersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

