/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.ListOfTextSegmentsCopier;
import software.amazon.awssdk.services.comprehend.model.TextSegment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectToxicContentRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, DetectToxicContentRequest> {
    private static final SdkField<List<TextSegment>> TEXT_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextSegments").getter(DetectToxicContentRequest.getter(DetectToxicContentRequest::textSegments)).setter(DetectToxicContentRequest.setter(Builder::textSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextSegments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DetectToxicContentRequest.getter(DetectToxicContentRequest::languageCodeAsString)).setter(DetectToxicContentRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_SEGMENTS_FIELD, LANGUAGE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectToxicContentRequest.memberNameToFieldInitializer();
    private final List<TextSegment> textSegments;
    private final String languageCode;

    private DetectToxicContentRequest(BuilderImpl builder) {
        super(builder);
        this.textSegments = builder.textSegments;
        this.languageCode = builder.languageCode;
    }

    public final boolean hasTextSegments() {
        return this.textSegments != null && !(this.textSegments instanceof SdkAutoConstructList);
    }

    public final List<TextSegment> textSegments() {
        return this.textSegments;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextSegments() ? this.textSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectToxicContentRequest)) {
            return false;
        }
        DetectToxicContentRequest other = (DetectToxicContentRequest)((Object)obj);
        return this.hasTextSegments() == other.hasTextSegments() && Objects.equals(this.textSegments(), other.textSegments()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DetectToxicContentRequest").add("TextSegments", (Object)(this.textSegments() == null ? null : "*** Sensitive Data Redacted ***")).add("LanguageCode", (Object)this.languageCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextSegments": {
                return Optional.ofNullable(clazz.cast(this.textSegments()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TextSegments", TEXT_SEGMENTS_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectToxicContentRequest, T> g) {
        return obj -> g.apply((DetectToxicContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private List<TextSegment> textSegments = DefaultSdkAutoConstructList.getInstance();
        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectToxicContentRequest model) {
            super(model);
            this.textSegments(model.textSegments);
            this.languageCode(model.languageCode);
        }

        public final List<TextSegment.Builder> getTextSegments() {
            List<TextSegment.Builder> result = ListOfTextSegmentsCopier.copyToBuilder(this.textSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextSegments(Collection<TextSegment.BuilderImpl> textSegments) {
            this.textSegments = ListOfTextSegmentsCopier.copyFromBuilder(textSegments);
        }

        @Override
        public final Builder textSegments(Collection<TextSegment> textSegments) {
            this.textSegments = ListOfTextSegmentsCopier.copy(textSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textSegments(TextSegment ... textSegments) {
            this.textSegments(Arrays.asList(textSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textSegments(Consumer<TextSegment.Builder> ... textSegments) {
            this.textSegments(Stream.of(textSegments).map(c -> (TextSegment)((TextSegment.Builder)TextSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectToxicContentRequest build() {
            return new DetectToxicContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectToxicContentRequest> {
        public Builder textSegments(Collection<TextSegment> var1);

        public Builder textSegments(TextSegment ... var1);

        public Builder textSegments(Consumer<TextSegment.Builder> ... var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

