/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopTargetedSentimentDetectionJobResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, StopTargetedSentimentDetectionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(StopTargetedSentimentDetectionJobResponse.getter(StopTargetedSentimentDetectionJobResponse::jobId)).setter(StopTargetedSentimentDetectionJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(StopTargetedSentimentDetectionJobResponse.getter(StopTargetedSentimentDetectionJobResponse::jobStatusAsString)).setter(StopTargetedSentimentDetectionJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StopTargetedSentimentDetectionJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final String jobStatus;

    private StopTargetedSentimentDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopTargetedSentimentDetectionJobResponse)) {
            return false;
        }
        StopTargetedSentimentDetectionJobResponse other = (StopTargetedSentimentDetectionJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopTargetedSentimentDetectionJobResponse").add("JobId", (Object)this.jobId()).add("JobStatus", (Object)this.jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopTargetedSentimentDetectionJobResponse, T> g) {
        return obj -> g.apply((StopTargetedSentimentDetectionJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StopTargetedSentimentDetectionJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobStatus(model.jobStatus);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        @Override
        public StopTargetedSentimentDetectionJobResponse build() {
            return new StopTargetedSentimentDetectionJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopTargetedSentimentDetectionJobResponse> {
        public Builder jobId(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);
    }
}

