/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierProperties;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDocumentClassifiersResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDocumentClassifiersResponse> {
    private static final SdkField<List<DocumentClassifierProperties>> DOCUMENT_CLASSIFIER_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentClassifierPropertiesList").getter(ListDocumentClassifiersResponse.getter(ListDocumentClassifiersResponse::documentClassifierPropertiesList)).setter(ListDocumentClassifiersResponse.setter(Builder::documentClassifierPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClassifierProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDocumentClassifiersResponse.getter(ListDocumentClassifiersResponse::nextToken)).setter(ListDocumentClassifiersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFIER_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDocumentClassifiersResponse.memberNameToFieldInitializer();
    private final List<DocumentClassifierProperties> documentClassifierPropertiesList;
    private final String nextToken;

    private ListDocumentClassifiersResponse(BuilderImpl builder) {
        super(builder);
        this.documentClassifierPropertiesList = builder.documentClassifierPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDocumentClassifierPropertiesList() {
        return this.documentClassifierPropertiesList != null && !(this.documentClassifierPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<DocumentClassifierProperties> documentClassifierPropertiesList() {
        return this.documentClassifierPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentClassifierPropertiesList() ? this.documentClassifierPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentClassifiersResponse)) {
            return false;
        }
        ListDocumentClassifiersResponse other = (ListDocumentClassifiersResponse)((Object)obj);
        return this.hasDocumentClassifierPropertiesList() == other.hasDocumentClassifierPropertiesList() && Objects.equals(this.documentClassifierPropertiesList(), other.documentClassifierPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDocumentClassifiersResponse").add("DocumentClassifierPropertiesList", this.hasDocumentClassifierPropertiesList() ? this.documentClassifierPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassifierPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentClassifierPropertiesList", DOCUMENT_CLASSIFIER_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDocumentClassifiersResponse, T> g) {
        return obj -> g.apply((ListDocumentClassifiersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClassifierProperties> documentClassifierPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentClassifiersResponse model) {
            super(model);
            this.documentClassifierPropertiesList(model.documentClassifierPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<DocumentClassifierProperties.Builder> getDocumentClassifierPropertiesList() {
            List<DocumentClassifierProperties.Builder> result = DocumentClassifierPropertiesListCopier.copyToBuilder(this.documentClassifierPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentClassifierPropertiesList(Collection<DocumentClassifierProperties.BuilderImpl> documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList = DocumentClassifierPropertiesListCopier.copyFromBuilder(documentClassifierPropertiesList);
        }

        @Override
        public final Builder documentClassifierPropertiesList(Collection<DocumentClassifierProperties> documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList = DocumentClassifierPropertiesListCopier.copy(documentClassifierPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierPropertiesList(DocumentClassifierProperties ... documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList(Arrays.asList(documentClassifierPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentClassifierPropertiesList(Consumer<DocumentClassifierProperties.Builder> ... documentClassifierPropertiesList) {
            this.documentClassifierPropertiesList(Stream.of(documentClassifierPropertiesList).map(c -> (DocumentClassifierProperties)((DocumentClassifierProperties.Builder)DocumentClassifierProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDocumentClassifiersResponse build() {
            return new ListDocumentClassifiersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDocumentClassifiersResponse> {
        public Builder documentClassifierPropertiesList(Collection<DocumentClassifierProperties> var1);

        public Builder documentClassifierPropertiesList(DocumentClassifierProperties ... var1);

        public Builder documentClassifierPropertiesList(Consumer<DocumentClassifierProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

