/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectEntitiesRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, DetectEntitiesRequest> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(DetectEntitiesRequest.getter(DetectEntitiesRequest::text)).setter(DetectEntitiesRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DetectEntitiesRequest.getter(DetectEntitiesRequest::languageCodeAsString)).setter(DetectEntitiesRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(DetectEntitiesRequest.getter(DetectEntitiesRequest::endpointArn)).setter(DetectEntitiesRequest.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Bytes").getter(DetectEntitiesRequest.getter(DetectEntitiesRequest::bytes)).setter(DetectEntitiesRequest.setter(Builder::bytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bytes").build()}).build();
    private static final SdkField<DocumentReaderConfig> DOCUMENT_READER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentReaderConfig").getter(DetectEntitiesRequest.getter(DetectEntitiesRequest::documentReaderConfig)).setter(DetectEntitiesRequest.setter(Builder::documentReaderConfig)).constructor(DocumentReaderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReaderConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, LANGUAGE_CODE_FIELD, ENDPOINT_ARN_FIELD, BYTES_FIELD, DOCUMENT_READER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Text", TEXT_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("EndpointArn", ENDPOINT_ARN_FIELD);
            this.put("Bytes", BYTES_FIELD);
            this.put("DocumentReaderConfig", DOCUMENT_READER_CONFIG_FIELD);
        }
    });
    private final String text;
    private final String languageCode;
    private final String endpointArn;
    private final SdkBytes bytes;
    private final DocumentReaderConfig documentReaderConfig;

    private DetectEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.languageCode = builder.languageCode;
        this.endpointArn = builder.endpointArn;
        this.bytes = builder.bytes;
        this.documentReaderConfig = builder.documentReaderConfig;
    }

    public final String text() {
        return this.text;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final SdkBytes bytes() {
        return this.bytes;
    }

    public final DocumentReaderConfig documentReaderConfig() {
        return this.documentReaderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentReaderConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesRequest)) {
            return false;
        }
        DetectEntitiesRequest other = (DetectEntitiesRequest)((Object)obj);
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.bytes(), other.bytes()) && Objects.equals(this.documentReaderConfig(), other.documentReaderConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DetectEntitiesRequest").add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("LanguageCode", (Object)this.languageCodeAsString()).add("EndpointArn", (Object)this.endpointArn()).add("Bytes", (Object)this.bytes()).add("DocumentReaderConfig", (Object)this.documentReaderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "Bytes": {
                return Optional.ofNullable(clazz.cast(this.bytes()));
            }
            case "DocumentReaderConfig": {
                return Optional.ofNullable(clazz.cast(this.documentReaderConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesRequest, T> g) {
        return obj -> g.apply((DetectEntitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String text;
        private String languageCode;
        private String endpointArn;
        private SdkBytes bytes;
        private DocumentReaderConfig documentReaderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesRequest model) {
            super(model);
            this.text(model.text);
            this.languageCode(model.languageCode);
            this.endpointArn(model.endpointArn);
            this.bytes(model.bytes);
            this.documentReaderConfig(model.documentReaderConfig);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final ByteBuffer getBytes() {
            return this.bytes == null ? null : this.bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            this.bytes(bytes == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        public final DocumentReaderConfig.Builder getDocumentReaderConfig() {
            return this.documentReaderConfig != null ? this.documentReaderConfig.toBuilder() : null;
        }

        public final void setDocumentReaderConfig(DocumentReaderConfig.BuilderImpl documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig != null ? documentReaderConfig.build() : null;
        }

        @Override
        public final Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectEntitiesRequest build() {
            return new DetectEntitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectEntitiesRequest> {
        public Builder text(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder endpointArn(String var1);

        public Builder bytes(SdkBytes var1);

        public Builder documentReaderConfig(DocumentReaderConfig var1);

        default public Builder documentReaderConfig(Consumer<DocumentReaderConfig.Builder> documentReaderConfig) {
            return this.documentReaderConfig((DocumentReaderConfig)((DocumentReaderConfig.Builder)DocumentReaderConfig.builder().applyMutation(documentReaderConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

