/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ListOfDescriptiveMentionIndicesCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfMentionsCopier;
import software.amazon.awssdk.services.comprehend.model.TargetedSentimentMention;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetedSentimentEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetedSentimentEntity> {
    private static final SdkField<List<Integer>> DESCRIPTIVE_MENTION_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DescriptiveMentionIndex").getter(TargetedSentimentEntity.getter(TargetedSentimentEntity::descriptiveMentionIndex)).setter(TargetedSentimentEntity.setter(Builder::descriptiveMentionIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescriptiveMentionIndex").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetedSentimentMention>> MENTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Mentions").getter(TargetedSentimentEntity.getter(TargetedSentimentEntity::mentions)).setter(TargetedSentimentEntity.setter(Builder::mentions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mentions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetedSentimentMention::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIVE_MENTION_INDEX_FIELD, MENTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetedSentimentEntity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Integer> descriptiveMentionIndex;
    private final List<TargetedSentimentMention> mentions;

    private TargetedSentimentEntity(BuilderImpl builder) {
        this.descriptiveMentionIndex = builder.descriptiveMentionIndex;
        this.mentions = builder.mentions;
    }

    public final boolean hasDescriptiveMentionIndex() {
        return this.descriptiveMentionIndex != null && !(this.descriptiveMentionIndex instanceof SdkAutoConstructList);
    }

    public final List<Integer> descriptiveMentionIndex() {
        return this.descriptiveMentionIndex;
    }

    public final boolean hasMentions() {
        return this.mentions != null && !(this.mentions instanceof SdkAutoConstructList);
    }

    public final List<TargetedSentimentMention> mentions() {
        return this.mentions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDescriptiveMentionIndex() ? this.descriptiveMentionIndex() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMentions() ? this.mentions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetedSentimentEntity)) {
            return false;
        }
        TargetedSentimentEntity other = (TargetedSentimentEntity)obj;
        return this.hasDescriptiveMentionIndex() == other.hasDescriptiveMentionIndex() && Objects.equals(this.descriptiveMentionIndex(), other.descriptiveMentionIndex()) && this.hasMentions() == other.hasMentions() && Objects.equals(this.mentions(), other.mentions());
    }

    public final String toString() {
        return ToString.builder((String)"TargetedSentimentEntity").add("DescriptiveMentionIndex", this.hasDescriptiveMentionIndex() ? this.descriptiveMentionIndex() : null).add("Mentions", this.hasMentions() ? this.mentions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DescriptiveMentionIndex": {
                return Optional.ofNullable(clazz.cast(this.descriptiveMentionIndex()));
            }
            case "Mentions": {
                return Optional.ofNullable(clazz.cast(this.mentions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DescriptiveMentionIndex", DESCRIPTIVE_MENTION_INDEX_FIELD);
        map.put("Mentions", MENTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetedSentimentEntity, T> g) {
        return obj -> g.apply((TargetedSentimentEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> descriptiveMentionIndex = DefaultSdkAutoConstructList.getInstance();
        private List<TargetedSentimentMention> mentions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TargetedSentimentEntity model) {
            this.descriptiveMentionIndex(model.descriptiveMentionIndex);
            this.mentions(model.mentions);
        }

        public final Collection<Integer> getDescriptiveMentionIndex() {
            if (this.descriptiveMentionIndex instanceof SdkAutoConstructList) {
                return null;
            }
            return this.descriptiveMentionIndex;
        }

        public final void setDescriptiveMentionIndex(Collection<Integer> descriptiveMentionIndex) {
            this.descriptiveMentionIndex = ListOfDescriptiveMentionIndicesCopier.copy(descriptiveMentionIndex);
        }

        @Override
        public final Builder descriptiveMentionIndex(Collection<Integer> descriptiveMentionIndex) {
            this.descriptiveMentionIndex = ListOfDescriptiveMentionIndicesCopier.copy(descriptiveMentionIndex);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptiveMentionIndex(Integer ... descriptiveMentionIndex) {
            this.descriptiveMentionIndex(Arrays.asList(descriptiveMentionIndex));
            return this;
        }

        public final List<TargetedSentimentMention.Builder> getMentions() {
            List<TargetedSentimentMention.Builder> result = ListOfMentionsCopier.copyToBuilder(this.mentions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMentions(Collection<TargetedSentimentMention.BuilderImpl> mentions) {
            this.mentions = ListOfMentionsCopier.copyFromBuilder(mentions);
        }

        @Override
        public final Builder mentions(Collection<TargetedSentimentMention> mentions) {
            this.mentions = ListOfMentionsCopier.copy(mentions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mentions(TargetedSentimentMention ... mentions) {
            this.mentions(Arrays.asList(mentions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mentions(Consumer<TargetedSentimentMention.Builder> ... mentions) {
            this.mentions(Stream.of(mentions).map(c -> (TargetedSentimentMention)((TargetedSentimentMention.Builder)TargetedSentimentMention.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TargetedSentimentEntity build() {
            return new TargetedSentimentEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetedSentimentEntity> {
        public Builder descriptiveMentionIndex(Collection<Integer> var1);

        public Builder descriptiveMentionIndex(Integer ... var1);

        public Builder mentions(Collection<TargetedSentimentMention> var1);

        public Builder mentions(TargetedSentimentMention ... var1);

        public Builder mentions(Consumer<TargetedSentimentMention.Builder> ... var1);
    }
}

