/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerSummary> {
    private static final SdkField<String> RECOGNIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecognizerName").getter(EntityRecognizerSummary.getter(EntityRecognizerSummary::recognizerName)).setter(EntityRecognizerSummary.setter(Builder::recognizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerName").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfVersions").getter(EntityRecognizerSummary.getter(EntityRecognizerSummary::numberOfVersions)).setter(EntityRecognizerSummary.setter(Builder::numberOfVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfVersions").build()}).build();
    private static final SdkField<Instant> LATEST_VERSION_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestVersionCreatedAt").getter(EntityRecognizerSummary.getter(EntityRecognizerSummary::latestVersionCreatedAt)).setter(EntityRecognizerSummary.setter(Builder::latestVersionCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionCreatedAt").build()}).build();
    private static final SdkField<String> LATEST_VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestVersionName").getter(EntityRecognizerSummary.getter(EntityRecognizerSummary::latestVersionName)).setter(EntityRecognizerSummary.setter(Builder::latestVersionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionName").build()}).build();
    private static final SdkField<String> LATEST_VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestVersionStatus").getter(EntityRecognizerSummary.getter(EntityRecognizerSummary::latestVersionStatusAsString)).setter(EntityRecognizerSummary.setter(Builder::latestVersionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOGNIZER_NAME_FIELD, NUMBER_OF_VERSIONS_FIELD, LATEST_VERSION_CREATED_AT_FIELD, LATEST_VERSION_NAME_FIELD, LATEST_VERSION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntityRecognizerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recognizerName;
    private final Integer numberOfVersions;
    private final Instant latestVersionCreatedAt;
    private final String latestVersionName;
    private final String latestVersionStatus;

    private EntityRecognizerSummary(BuilderImpl builder) {
        this.recognizerName = builder.recognizerName;
        this.numberOfVersions = builder.numberOfVersions;
        this.latestVersionCreatedAt = builder.latestVersionCreatedAt;
        this.latestVersionName = builder.latestVersionName;
        this.latestVersionStatus = builder.latestVersionStatus;
    }

    public final String recognizerName() {
        return this.recognizerName;
    }

    public final Integer numberOfVersions() {
        return this.numberOfVersions;
    }

    public final Instant latestVersionCreatedAt() {
        return this.latestVersionCreatedAt;
    }

    public final String latestVersionName() {
        return this.latestVersionName;
    }

    public final ModelStatus latestVersionStatus() {
        return ModelStatus.fromValue(this.latestVersionStatus);
    }

    public final String latestVersionStatusAsString() {
        return this.latestVersionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recognizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerSummary)) {
            return false;
        }
        EntityRecognizerSummary other = (EntityRecognizerSummary)obj;
        return Objects.equals(this.recognizerName(), other.recognizerName()) && Objects.equals(this.numberOfVersions(), other.numberOfVersions()) && Objects.equals(this.latestVersionCreatedAt(), other.latestVersionCreatedAt()) && Objects.equals(this.latestVersionName(), other.latestVersionName()) && Objects.equals(this.latestVersionStatusAsString(), other.latestVersionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EntityRecognizerSummary").add("RecognizerName", (Object)this.recognizerName()).add("NumberOfVersions", (Object)this.numberOfVersions()).add("LatestVersionCreatedAt", (Object)this.latestVersionCreatedAt()).add("LatestVersionName", (Object)this.latestVersionName()).add("LatestVersionStatus", (Object)this.latestVersionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecognizerName": {
                return Optional.ofNullable(clazz.cast(this.recognizerName()));
            }
            case "NumberOfVersions": {
                return Optional.ofNullable(clazz.cast(this.numberOfVersions()));
            }
            case "LatestVersionCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.latestVersionCreatedAt()));
            }
            case "LatestVersionName": {
                return Optional.ofNullable(clazz.cast(this.latestVersionName()));
            }
            case "LatestVersionStatus": {
                return Optional.ofNullable(clazz.cast(this.latestVersionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecognizerName", RECOGNIZER_NAME_FIELD);
        map.put("NumberOfVersions", NUMBER_OF_VERSIONS_FIELD);
        map.put("LatestVersionCreatedAt", LATEST_VERSION_CREATED_AT_FIELD);
        map.put("LatestVersionName", LATEST_VERSION_NAME_FIELD);
        map.put("LatestVersionStatus", LATEST_VERSION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerSummary, T> g) {
        return obj -> g.apply((EntityRecognizerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recognizerName;
        private Integer numberOfVersions;
        private Instant latestVersionCreatedAt;
        private String latestVersionName;
        private String latestVersionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerSummary model) {
            this.recognizerName(model.recognizerName);
            this.numberOfVersions(model.numberOfVersions);
            this.latestVersionCreatedAt(model.latestVersionCreatedAt);
            this.latestVersionName(model.latestVersionName);
            this.latestVersionStatus(model.latestVersionStatus);
        }

        public final String getRecognizerName() {
            return this.recognizerName;
        }

        public final void setRecognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
        }

        @Override
        public final Builder recognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
            return this;
        }

        public final Integer getNumberOfVersions() {
            return this.numberOfVersions;
        }

        public final void setNumberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
        }

        @Override
        public final Builder numberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
            return this;
        }

        public final Instant getLatestVersionCreatedAt() {
            return this.latestVersionCreatedAt;
        }

        public final void setLatestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
        }

        @Override
        public final Builder latestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
            return this;
        }

        public final String getLatestVersionName() {
            return this.latestVersionName;
        }

        public final void setLatestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
        }

        @Override
        public final Builder latestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
            return this;
        }

        public final String getLatestVersionStatus() {
            return this.latestVersionStatus;
        }

        public final void setLatestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
        }

        @Override
        public final Builder latestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
            return this;
        }

        @Override
        public final Builder latestVersionStatus(ModelStatus latestVersionStatus) {
            this.latestVersionStatus(latestVersionStatus == null ? null : latestVersionStatus.toString());
            return this;
        }

        public EntityRecognizerSummary build() {
            return new EntityRecognizerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerSummary> {
        public Builder recognizerName(String var1);

        public Builder numberOfVersions(Integer var1);

        public Builder latestVersionCreatedAt(Instant var1);

        public Builder latestVersionName(String var1);

        public Builder latestVersionStatus(String var1);

        public Builder latestVersionStatus(ModelStatus var1);
    }
}

