/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.DatasetStatus;
import software.amazon.awssdk.services.comprehend.model.DatasetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetProperties> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DatasetProperties.getter(DatasetProperties::datasetArn)).setter(DatasetProperties.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DatasetProperties.getter(DatasetProperties::datasetName)).setter(DatasetProperties.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(DatasetProperties.getter(DatasetProperties::datasetTypeAsString)).setter(DatasetProperties.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<String> DATASET_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetS3Uri").getter(DatasetProperties.getter(DatasetProperties::datasetS3Uri)).setter(DatasetProperties.setter(Builder::datasetS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetS3Uri").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DatasetProperties.getter(DatasetProperties::description)).setter(DatasetProperties.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DatasetProperties.getter(DatasetProperties::statusAsString)).setter(DatasetProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DatasetProperties.getter(DatasetProperties::message)).setter(DatasetProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfDocuments").getter(DatasetProperties.getter(DatasetProperties::numberOfDocuments)).setter(DatasetProperties.setter(Builder::numberOfDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDocuments").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DatasetProperties.getter(DatasetProperties::creationTime)).setter(DatasetProperties.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DatasetProperties.getter(DatasetProperties::endTime)).setter(DatasetProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ARN_FIELD, DATASET_NAME_FIELD, DATASET_TYPE_FIELD, DATASET_S3_URI_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, MESSAGE_FIELD, NUMBER_OF_DOCUMENTS_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatasetProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetArn;
    private final String datasetName;
    private final String datasetType;
    private final String datasetS3Uri;
    private final String description;
    private final String status;
    private final String message;
    private final Long numberOfDocuments;
    private final Instant creationTime;
    private final Instant endTime;

    private DatasetProperties(BuilderImpl builder) {
        this.datasetArn = builder.datasetArn;
        this.datasetName = builder.datasetName;
        this.datasetType = builder.datasetType;
        this.datasetS3Uri = builder.datasetS3Uri;
        this.description = builder.description;
        this.status = builder.status;
        this.message = builder.message;
        this.numberOfDocuments = builder.numberOfDocuments;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final DatasetType datasetType() {
        return DatasetType.fromValue(this.datasetType);
    }

    public final String datasetTypeAsString() {
        return this.datasetType;
    }

    public final String datasetS3Uri() {
        return this.datasetS3Uri;
    }

    public final String description() {
        return this.description;
    }

    public final DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Long numberOfDocuments() {
        return this.numberOfDocuments;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetProperties)) {
            return false;
        }
        DatasetProperties other = (DatasetProperties)obj;
        return Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetTypeAsString(), other.datasetTypeAsString()) && Objects.equals(this.datasetS3Uri(), other.datasetS3Uri()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.numberOfDocuments(), other.numberOfDocuments()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"DatasetProperties").add("DatasetArn", (Object)this.datasetArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetType", (Object)this.datasetTypeAsString()).add("DatasetS3Uri", (Object)this.datasetS3Uri()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("NumberOfDocuments", (Object)this.numberOfDocuments()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetTypeAsString()));
            }
            case "DatasetS3Uri": {
                return Optional.ofNullable(clazz.cast(this.datasetS3Uri()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "NumberOfDocuments": {
                return Optional.ofNullable(clazz.cast(this.numberOfDocuments()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetType", DATASET_TYPE_FIELD);
        map.put("DatasetS3Uri", DATASET_S3_URI_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("NumberOfDocuments", NUMBER_OF_DOCUMENTS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetProperties, T> g) {
        return obj -> g.apply((DatasetProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetArn;
        private String datasetName;
        private String datasetType;
        private String datasetS3Uri;
        private String description;
        private String status;
        private String message;
        private Long numberOfDocuments;
        private Instant creationTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetProperties model) {
            this.datasetArn(model.datasetArn);
            this.datasetName(model.datasetName);
            this.datasetType(model.datasetType);
            this.datasetS3Uri(model.datasetS3Uri);
            this.description(model.description);
            this.status(model.status);
            this.message(model.message);
            this.numberOfDocuments(model.numberOfDocuments);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDatasetS3Uri() {
            return this.datasetS3Uri;
        }

        public final void setDatasetS3Uri(String datasetS3Uri) {
            this.datasetS3Uri = datasetS3Uri;
        }

        @Override
        public final Builder datasetS3Uri(String datasetS3Uri) {
            this.datasetS3Uri = datasetS3Uri;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getNumberOfDocuments() {
            return this.numberOfDocuments;
        }

        public final void setNumberOfDocuments(Long numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
        }

        @Override
        public final Builder numberOfDocuments(Long numberOfDocuments) {
            this.numberOfDocuments = numberOfDocuments;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public DatasetProperties build() {
            return new DatasetProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetProperties> {
        public Builder datasetArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetType(String var1);

        public Builder datasetType(DatasetType var1);

        public Builder datasetS3Uri(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder message(String var1);

        public Builder numberOfDocuments(Long var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

