/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.DatasetInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.DatasetType;
import software.amazon.awssdk.services.comprehend.model.Tag;
import software.amazon.awssdk.services.comprehend.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, CreateDatasetRequest> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(CreateDatasetRequest.getter(CreateDatasetRequest::flywheelArn)).setter(CreateDatasetRequest.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetName)).setter(CreateDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetType").getter(CreateDatasetRequest.getter(CreateDatasetRequest::datasetTypeAsString)).setter(CreateDatasetRequest.setter(Builder::datasetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDatasetRequest.getter(CreateDatasetRequest::description)).setter(CreateDatasetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DatasetInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(CreateDatasetRequest.getter(CreateDatasetRequest::inputDataConfig)).setter(CreateDatasetRequest.setter(Builder::inputDataConfig)).constructor(DatasetInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateDatasetRequest.getter(CreateDatasetRequest::clientRequestToken)).setter(CreateDatasetRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDatasetRequest.getter(CreateDatasetRequest::tags)).setter(CreateDatasetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD, DATASET_NAME_FIELD, DATASET_TYPE_FIELD, DESCRIPTION_FIELD, INPUT_DATA_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
            this.put("DatasetName", DATASET_NAME_FIELD);
            this.put("DatasetType", DATASET_TYPE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String flywheelArn;
    private final String datasetName;
    private final String datasetType;
    private final String description;
    private final DatasetInputDataConfig inputDataConfig;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
        this.datasetName = builder.datasetName;
        this.datasetType = builder.datasetType;
        this.description = builder.description;
        this.inputDataConfig = builder.inputDataConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final DatasetType datasetType() {
        return DatasetType.fromValue(this.datasetType);
    }

    public final String datasetTypeAsString() {
        return this.datasetType;
    }

    public final String description() {
        return this.description;
    }

    public final DatasetInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)((Object)obj);
        return Objects.equals(this.flywheelArn(), other.flywheelArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetTypeAsString(), other.datasetTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetRequest").add("FlywheelArn", (Object)this.flywheelArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetType", (Object)this.datasetTypeAsString()).add("Description", (Object)this.description()).add("InputDataConfig", (Object)this.inputDataConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetType": {
                return Optional.ofNullable(clazz.cast(this.datasetTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String flywheelArn;
        private String datasetName;
        private String datasetType;
        private String description;
        private DatasetInputDataConfig inputDataConfig;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            this.flywheelArn(model.flywheelArn);
            this.datasetName(model.datasetName);
            this.datasetType(model.datasetType);
            this.description(model.description);
            this.inputDataConfig(model.inputDataConfig);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetType() {
            return this.datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DatasetInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(DatasetInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(DatasetInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetRequest> {
        public Builder flywheelArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetType(String var1);

        public Builder datasetType(DatasetType var1);

        public Builder description(String var1);

        public Builder inputDataConfig(DatasetInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<DatasetInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((DatasetInputDataConfig)((DatasetInputDataConfig.Builder)DatasetInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

