/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EventsDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.EventsDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventsDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEventsDetectionJobsResponse> {
    private static final SdkField<List<EventsDetectionJobProperties>> EVENTS_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventsDetectionJobPropertiesList").getter(ListEventsDetectionJobsResponse.getter(ListEventsDetectionJobsResponse::eventsDetectionJobPropertiesList)).setter(ListEventsDetectionJobsResponse.setter(Builder::eventsDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventsDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEventsDetectionJobsResponse.getter(ListEventsDetectionJobsResponse::nextToken)).setter(ListEventsDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventsDetectionJobPropertiesList", EVENTS_DETECTION_JOB_PROPERTIES_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<EventsDetectionJobProperties> eventsDetectionJobPropertiesList;
    private final String nextToken;

    private ListEventsDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.eventsDetectionJobPropertiesList = builder.eventsDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventsDetectionJobPropertiesList() {
        return this.eventsDetectionJobPropertiesList != null && !(this.eventsDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<EventsDetectionJobProperties> eventsDetectionJobPropertiesList() {
        return this.eventsDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventsDetectionJobPropertiesList() ? this.eventsDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventsDetectionJobsResponse)) {
            return false;
        }
        ListEventsDetectionJobsResponse other = (ListEventsDetectionJobsResponse)((Object)obj);
        return this.hasEventsDetectionJobPropertiesList() == other.hasEventsDetectionJobPropertiesList() && Objects.equals(this.eventsDetectionJobPropertiesList(), other.eventsDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEventsDetectionJobsResponse").add("EventsDetectionJobPropertiesList", this.hasEventsDetectionJobPropertiesList() ? this.eventsDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventsDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.eventsDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEventsDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListEventsDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EventsDetectionJobProperties> eventsDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventsDetectionJobsResponse model) {
            super(model);
            this.eventsDetectionJobPropertiesList(model.eventsDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<EventsDetectionJobProperties.Builder> getEventsDetectionJobPropertiesList() {
            List<EventsDetectionJobProperties.Builder> result = EventsDetectionJobPropertiesListCopier.copyToBuilder(this.eventsDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventsDetectionJobPropertiesList(Collection<EventsDetectionJobProperties.BuilderImpl> eventsDetectionJobPropertiesList) {
            this.eventsDetectionJobPropertiesList = EventsDetectionJobPropertiesListCopier.copyFromBuilder(eventsDetectionJobPropertiesList);
        }

        @Override
        public final Builder eventsDetectionJobPropertiesList(Collection<EventsDetectionJobProperties> eventsDetectionJobPropertiesList) {
            this.eventsDetectionJobPropertiesList = EventsDetectionJobPropertiesListCopier.copy(eventsDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsDetectionJobPropertiesList(EventsDetectionJobProperties ... eventsDetectionJobPropertiesList) {
            this.eventsDetectionJobPropertiesList(Arrays.asList(eventsDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventsDetectionJobPropertiesList(Consumer<EventsDetectionJobProperties.Builder> ... eventsDetectionJobPropertiesList) {
            this.eventsDetectionJobPropertiesList(Stream.of(eventsDetectionJobPropertiesList).map(c -> (EventsDetectionJobProperties)((EventsDetectionJobProperties.Builder)EventsDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventsDetectionJobsResponse build() {
            return new ListEventsDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEventsDetectionJobsResponse> {
        public Builder eventsDetectionJobPropertiesList(Collection<EventsDetectionJobProperties> var1);

        public Builder eventsDetectionJobPropertiesList(EventsDetectionJobProperties ... var1);

        public Builder eventsDetectionJobPropertiesList(Consumer<EventsDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

