/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.DataSecurityConfig;
import software.amazon.awssdk.services.comprehend.model.ModelType;
import software.amazon.awssdk.services.comprehend.model.Tag;
import software.amazon.awssdk.services.comprehend.model.TagListCopier;
import software.amazon.awssdk.services.comprehend.model.TaskConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlywheelRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, CreateFlywheelRequest> {
    private static final SdkField<String> FLYWHEEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelName").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::flywheelName)).setter(CreateFlywheelRequest.setter(Builder::flywheelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelName").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelArn").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::activeModelArn)).setter(CreateFlywheelRequest.setter(Builder::activeModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::dataAccessRoleArn)).setter(CreateFlywheelRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<TaskConfig> TASK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskConfig").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::taskConfig)).setter(CreateFlywheelRequest.setter(Builder::taskConfig)).constructor(TaskConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfig").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelType").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::modelTypeAsString)).setter(CreateFlywheelRequest.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelType").build()}).build();
    private static final SdkField<String> DATA_LAKE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLakeS3Uri").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::dataLakeS3Uri)).setter(CreateFlywheelRequest.setter(Builder::dataLakeS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeS3Uri").build()}).build();
    private static final SdkField<DataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSecurityConfig").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::dataSecurityConfig)).setter(CreateFlywheelRequest.setter(Builder::dataSecurityConfig)).constructor(DataSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::clientRequestToken)).setter(CreateFlywheelRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFlywheelRequest.getter(CreateFlywheelRequest::tags)).setter(CreateFlywheelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_NAME_FIELD, ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TASK_CONFIG_FIELD, MODEL_TYPE_FIELD, DATA_LAKE_S3_URI_FIELD, DATA_SECURITY_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FlywheelName", FLYWHEEL_NAME_FIELD);
            this.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
            this.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
            this.put("TaskConfig", TASK_CONFIG_FIELD);
            this.put("ModelType", MODEL_TYPE_FIELD);
            this.put("DataLakeS3Uri", DATA_LAKE_S3_URI_FIELD);
            this.put("DataSecurityConfig", DATA_SECURITY_CONFIG_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String flywheelName;
    private final String activeModelArn;
    private final String dataAccessRoleArn;
    private final TaskConfig taskConfig;
    private final String modelType;
    private final String dataLakeS3Uri;
    private final DataSecurityConfig dataSecurityConfig;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateFlywheelRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelName = builder.flywheelName;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.taskConfig = builder.taskConfig;
        this.modelType = builder.modelType;
        this.dataLakeS3Uri = builder.dataLakeS3Uri;
        this.dataSecurityConfig = builder.dataSecurityConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public final String flywheelName() {
        return this.flywheelName;
    }

    public final String activeModelArn() {
        return this.activeModelArn;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final TaskConfig taskConfig() {
        return this.taskConfig;
    }

    public final ModelType modelType() {
        return ModelType.fromValue(this.modelType);
    }

    public final String modelTypeAsString() {
        return this.modelType;
    }

    public final String dataLakeS3Uri() {
        return this.dataLakeS3Uri;
    }

    public final DataSecurityConfig dataSecurityConfig() {
        return this.dataSecurityConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSecurityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlywheelRequest)) {
            return false;
        }
        CreateFlywheelRequest other = (CreateFlywheelRequest)((Object)obj);
        return Objects.equals(this.flywheelName(), other.flywheelName()) && Objects.equals(this.activeModelArn(), other.activeModelArn()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.taskConfig(), other.taskConfig()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.dataLakeS3Uri(), other.dataLakeS3Uri()) && Objects.equals(this.dataSecurityConfig(), other.dataSecurityConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFlywheelRequest").add("FlywheelName", (Object)this.flywheelName()).add("ActiveModelArn", (Object)this.activeModelArn()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("TaskConfig", (Object)this.taskConfig()).add("ModelType", (Object)this.modelTypeAsString()).add("DataLakeS3Uri", (Object)this.dataLakeS3Uri()).add("DataSecurityConfig", (Object)this.dataSecurityConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelName": {
                return Optional.ofNullable(clazz.cast(this.flywheelName()));
            }
            case "ActiveModelArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelArn()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "TaskConfig": {
                return Optional.ofNullable(clazz.cast(this.taskConfig()));
            }
            case "ModelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "DataLakeS3Uri": {
                return Optional.ofNullable(clazz.cast(this.dataLakeS3Uri()));
            }
            case "DataSecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSecurityConfig()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlywheelRequest, T> g) {
        return obj -> g.apply((CreateFlywheelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String flywheelName;
        private String activeModelArn;
        private String dataAccessRoleArn;
        private TaskConfig taskConfig;
        private String modelType;
        private String dataLakeS3Uri;
        private DataSecurityConfig dataSecurityConfig;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlywheelRequest model) {
            super(model);
            this.flywheelName(model.flywheelName);
            this.activeModelArn(model.activeModelArn);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.taskConfig(model.taskConfig);
            this.modelType(model.modelType);
            this.dataLakeS3Uri(model.dataLakeS3Uri);
            this.dataSecurityConfig(model.dataSecurityConfig);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getFlywheelName() {
            return this.flywheelName;
        }

        public final void setFlywheelName(String flywheelName) {
            this.flywheelName = flywheelName;
        }

        @Override
        public final Builder flywheelName(String flywheelName) {
            this.flywheelName = flywheelName;
            return this;
        }

        public final String getActiveModelArn() {
            return this.activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final TaskConfig.Builder getTaskConfig() {
            return this.taskConfig != null ? this.taskConfig.toBuilder() : null;
        }

        public final void setTaskConfig(TaskConfig.BuilderImpl taskConfig) {
            this.taskConfig = taskConfig != null ? taskConfig.build() : null;
        }

        @Override
        public final Builder taskConfig(TaskConfig taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelType modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getDataLakeS3Uri() {
            return this.dataLakeS3Uri;
        }

        public final void setDataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
        }

        @Override
        public final Builder dataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        public final DataSecurityConfig.Builder getDataSecurityConfig() {
            return this.dataSecurityConfig != null ? this.dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(DataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlywheelRequest build() {
            return new CreateFlywheelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlywheelRequest> {
        public Builder flywheelName(String var1);

        public Builder activeModelArn(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder taskConfig(TaskConfig var1);

        default public Builder taskConfig(Consumer<TaskConfig.Builder> taskConfig) {
            return this.taskConfig((TaskConfig)((TaskConfig.Builder)TaskConfig.builder().applyMutation(taskConfig)).build());
        }

        public Builder modelType(String var1);

        public Builder modelType(ModelType var1);

        public Builder dataLakeS3Uri(String var1);

        public Builder dataSecurityConfig(DataSecurityConfig var1);

        default public Builder dataSecurityConfig(Consumer<DataSecurityConfig.Builder> dataSecurityConfig) {
            return this.dataSecurityConfig((DataSecurityConfig)((DataSecurityConfig.Builder)DataSecurityConfig.builder().applyMutation(dataSecurityConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

