/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.RelationshipType;
import software.amazon.awssdk.services.comprehend.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationshipsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationshipsListItem> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ids").getter(RelationshipsListItem.getter(RelationshipsListItem::ids)).setter(RelationshipsListItem.setter(Builder::ids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RelationshipsListItem.getter(RelationshipsListItem::typeAsString)).setter(RelationshipsListItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> ids;
    private final String type;

    private RelationshipsListItem(BuilderImpl builder) {
        this.ids = builder.ids;
        this.type = builder.type;
    }

    public final boolean hasIds() {
        return this.ids != null && !(this.ids instanceof SdkAutoConstructList);
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final RelationshipType type() {
        return RelationshipType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIds() ? this.ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationshipsListItem)) {
            return false;
        }
        RelationshipsListItem other = (RelationshipsListItem)obj;
        return this.hasIds() == other.hasIds() && Objects.equals(this.ids(), other.ids()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RelationshipsListItem").add("Ids", this.hasIds() ? this.ids() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationshipsListItem, T> g) {
        return obj -> g.apply((RelationshipsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationshipsListItem model) {
            this.ids(model.ids);
            this.type(model.type);
        }

        public final Collection<String> getIds() {
            if (this.ids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = StringListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = StringListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RelationshipsListItem build() {
            return new RelationshipsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationshipsListItem> {
        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder type(String var1);

        public Builder type(RelationshipType var1);
    }
}

