/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.services.comprehend.model.SentimentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectSentimentItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectSentimentItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(BatchDetectSentimentItemResult.getter(BatchDetectSentimentItemResult::index)).setter(BatchDetectSentimentItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sentiment").getter(BatchDetectSentimentItemResult.getter(BatchDetectSentimentItemResult::sentimentAsString)).setter(BatchDetectSentimentItemResult.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()}).build();
    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SentimentScore").getter(BatchDetectSentimentItemResult.getter(BatchDetectSentimentItemResult::sentimentScore)).setter(BatchDetectSentimentItemResult.setter(Builder::sentimentScore)).constructor(SentimentScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, SENTIMENT_FIELD, SENTIMENT_SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private BatchDetectSentimentItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public final Integer index() {
        return this.index;
    }

    public final SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public final String sentimentAsString() {
        return this.sentiment;
    }

    public final SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentItemResult)) {
            return false;
        }
        BatchDetectSentimentItemResult other = (BatchDetectSentimentItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetectSentimentItemResult").add("Index", (Object)this.index()).add("Sentiment", (Object)this.sentimentAsString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "SentimentScore": {
                return Optional.ofNullable(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSentimentItemResult, T> g) {
        return obj -> g.apply((BatchDetectSentimentItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentItemResult model) {
            this.index(model.index);
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public BatchDetectSentimentItemResult build() {
            return new BatchDetectSentimentItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectSentimentItemResult> {
        public Builder index(Integer var1);

        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().applyMutation(sentimentScore)).build());
        }
    }
}

