/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClientBuilder;
import software.amazon.awssdk.services.comprehend.ComprehendServiceClientConfiguration;
import software.amazon.awssdk.services.comprehend.DefaultComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.DefaultComprehendBaseClientBuilder;
import software.amazon.awssdk.services.comprehend.endpoints.ComprehendEndpointProvider;

@SdkInternalApi
final class DefaultComprehendAsyncClientBuilder
extends DefaultComprehendBaseClientBuilder<ComprehendAsyncClientBuilder, ComprehendAsyncClient>
implements ComprehendAsyncClientBuilder {
    DefaultComprehendAsyncClientBuilder() {
    }

    @Override
    public DefaultComprehendAsyncClientBuilder endpointProvider(ComprehendEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ComprehendAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultComprehendAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ComprehendServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultComprehendAsyncClient client = new DefaultComprehendAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ComprehendServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ComprehendServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

