/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;

public class ListEntityRecognizerSummariesIterable
implements SdkIterable<ListEntityRecognizerSummariesResponse> {
    private final ComprehendClient client;
    private final ListEntityRecognizerSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntityRecognizerSummariesIterable(ComprehendClient client, ListEntityRecognizerSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntityRecognizerSummariesResponseFetcher();
    }

    public Iterator<ListEntityRecognizerSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEntityRecognizerSummariesResponseFetcher
    implements SyncPageFetcher<ListEntityRecognizerSummariesResponse> {
        private ListEntityRecognizerSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityRecognizerSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntityRecognizerSummariesResponse nextPage(ListEntityRecognizerSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListEntityRecognizerSummariesIterable.this.client.listEntityRecognizerSummaries(ListEntityRecognizerSummariesIterable.this.firstRequest);
            }
            return ListEntityRecognizerSummariesIterable.this.client.listEntityRecognizerSummaries((ListEntityRecognizerSummariesRequest)((Object)ListEntityRecognizerSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

