/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;

public class ListDocumentClassificationJobsPublisher
implements SdkPublisher<ListDocumentClassificationJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListDocumentClassificationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDocumentClassificationJobsPublisher(ComprehendAsyncClient client, ListDocumentClassificationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDocumentClassificationJobsPublisher(ComprehendAsyncClient client, ListDocumentClassificationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDocumentClassificationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDocumentClassificationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDocumentClassificationJobsResponseFetcher
    implements AsyncPageFetcher<ListDocumentClassificationJobsResponse> {
        private ListDocumentClassificationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassificationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDocumentClassificationJobsResponse> nextPage(ListDocumentClassificationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassificationJobsPublisher.this.client.listDocumentClassificationJobs(ListDocumentClassificationJobsPublisher.this.firstRequest);
            }
            return ListDocumentClassificationJobsPublisher.this.client.listDocumentClassificationJobs((ListDocumentClassificationJobsRequest)((Object)ListDocumentClassificationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

