/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties;

public class ListPiiEntitiesDetectionJobsPublisher
implements SdkPublisher<ListPiiEntitiesDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListPiiEntitiesDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPiiEntitiesDetectionJobsPublisher(ComprehendAsyncClient client, ListPiiEntitiesDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPiiEntitiesDetectionJobsPublisher(ComprehendAsyncClient client, ListPiiEntitiesDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPiiEntitiesDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPiiEntitiesDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList() {
        Function<ListPiiEntitiesDetectionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.piiEntitiesDetectionJobPropertiesList() != null) {
                return response.piiEntitiesDetectionJobPropertiesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPiiEntitiesDetectionJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPiiEntitiesDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListPiiEntitiesDetectionJobsResponse> {
        private ListPiiEntitiesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPiiEntitiesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPiiEntitiesDetectionJobsResponse> nextPage(ListPiiEntitiesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPiiEntitiesDetectionJobsPublisher.this.client.listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsPublisher.this.firstRequest);
            }
            return ListPiiEntitiesDetectionJobsPublisher.this.client.listPiiEntitiesDetectionJobs((ListPiiEntitiesDetectionJobsRequest)((Object)ListPiiEntitiesDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

