/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;

public class ListDatasetsPublisher
implements SdkPublisher<ListDatasetsResponse> {
    private final ComprehendAsyncClient client;
    private final ListDatasetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetsPublisher(ComprehendAsyncClient client, ListDatasetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetsPublisher(ComprehendAsyncClient client, ListDatasetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDatasetsResponseFetcher
    implements AsyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetsResponse> nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsPublisher.this.client.listDatasets(ListDatasetsPublisher.this.firstRequest);
            }
            return ListDatasetsPublisher.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

