/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;

public class ListDatasetsIterable
implements SdkIterable<ListDatasetsResponse> {
    private final ComprehendClient client;
    private final ListDatasetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetsIterable(ComprehendClient client, ListDatasetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatasetsResponseFetcher();
    }

    public Iterator<ListDatasetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatasetsResponseFetcher
    implements SyncPageFetcher<ListDatasetsResponse> {
        private ListDatasetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetsResponse nextPage(ListDatasetsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetsIterable.this.client.listDatasets(ListDatasetsIterable.this.firstRequest);
            }
            return ListDatasetsIterable.this.client.listDatasets((ListDatasetsRequest)((Object)ListDatasetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

