/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse;

public class ListFlywheelIterationHistoryPublisher
implements SdkPublisher<ListFlywheelIterationHistoryResponse> {
    private final ComprehendAsyncClient client;
    private final ListFlywheelIterationHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlywheelIterationHistoryPublisher(ComprehendAsyncClient client, ListFlywheelIterationHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlywheelIterationHistoryPublisher(ComprehendAsyncClient client, ListFlywheelIterationHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlywheelIterationHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlywheelIterationHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFlywheelIterationHistoryResponseFetcher
    implements AsyncPageFetcher<ListFlywheelIterationHistoryResponse> {
        private ListFlywheelIterationHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListFlywheelIterationHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlywheelIterationHistoryResponse> nextPage(ListFlywheelIterationHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListFlywheelIterationHistoryPublisher.this.client.listFlywheelIterationHistory(ListFlywheelIterationHistoryPublisher.this.firstRequest);
            }
            return ListFlywheelIterationHistoryPublisher.this.client.listFlywheelIterationHistory((ListFlywheelIterationHistoryRequest)((Object)ListFlywheelIterationHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

