/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.internal.UserAgentUtils;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;

public class ListEntityRecognizersIterable
implements SdkIterable<ListEntityRecognizersResponse> {
    private final ComprehendClient client;
    private final ListEntityRecognizersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntityRecognizersIterable(ComprehendClient client, ListEntityRecognizersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntityRecognizersResponseFetcher();
    }

    public Iterator<ListEntityRecognizersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEntityRecognizersResponseFetcher
    implements SyncPageFetcher<ListEntityRecognizersResponse> {
        private ListEntityRecognizersResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityRecognizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntityRecognizersResponse nextPage(ListEntityRecognizersResponse previousPage) {
            if (previousPage == null) {
                return ListEntityRecognizersIterable.this.client.listEntityRecognizers(ListEntityRecognizersIterable.this.firstRequest);
            }
            return ListEntityRecognizersIterable.this.client.listEntityRecognizers((ListEntityRecognizersRequest)((Object)ListEntityRecognizersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

