/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentClassifierDataFormat {
    COMPREHEND_CSV("COMPREHEND_CSV"),
    AUGMENTED_MANIFEST("AUGMENTED_MANIFEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentClassifierDataFormat> VALUE_MAP;
    private final String value;

    private DocumentClassifierDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentClassifierDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentClassifierDataFormat> knownValues() {
        EnumSet<DocumentClassifierDataFormat> knownValues = EnumSet.allOf(DocumentClassifierDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentClassifierDataFormat.class, DocumentClassifierDataFormat::toString);
    }
}

