/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.internal.UserAgentUtils;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionJobProperties;

public class ListPiiEntitiesDetectionJobsIterable
implements SdkIterable<ListPiiEntitiesDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListPiiEntitiesDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPiiEntitiesDetectionJobsIterable(ComprehendClient client, ListPiiEntitiesDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPiiEntitiesDetectionJobsResponseFetcher();
    }

    public Iterator<ListPiiEntitiesDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PiiEntitiesDetectionJobProperties> piiEntitiesDetectionJobPropertiesList() {
        Function<ListPiiEntitiesDetectionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.piiEntitiesDetectionJobPropertiesList() != null) {
                return response.piiEntitiesDetectionJobPropertiesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPiiEntitiesDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListPiiEntitiesDetectionJobsResponse> {
        private ListPiiEntitiesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPiiEntitiesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPiiEntitiesDetectionJobsResponse nextPage(ListPiiEntitiesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPiiEntitiesDetectionJobsIterable.this.client.listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsIterable.this.firstRequest);
            }
            return ListPiiEntitiesDetectionJobsIterable.this.client.listPiiEntitiesDetectionJobs((ListPiiEntitiesDetectionJobsRequest)((Object)ListPiiEntitiesDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

