/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SyntaxLanguageCode {
    EN("en"),
    ES("es"),
    FR("fr"),
    DE("de"),
    IT("it"),
    PT("pt"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SyntaxLanguageCode> VALUE_MAP;
    private final String value;

    private SyntaxLanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SyntaxLanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SyntaxLanguageCode> knownValues() {
        EnumSet<SyntaxLanguageCode> knownValues = EnumSet.allOf(SyntaxLanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SyntaxLanguageCode.class, SyntaxLanguageCode::toString);
    }
}

