/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlywheelRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, UpdateFlywheelRequest> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(UpdateFlywheelRequest.getter(UpdateFlywheelRequest::flywheelArn)).setter(UpdateFlywheelRequest.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelArn").getter(UpdateFlywheelRequest.getter(UpdateFlywheelRequest::activeModelArn)).setter(UpdateFlywheelRequest.setter(Builder::activeModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(UpdateFlywheelRequest.getter(UpdateFlywheelRequest::dataAccessRoleArn)).setter(UpdateFlywheelRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<UpdateDataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSecurityConfig").getter(UpdateFlywheelRequest.getter(UpdateFlywheelRequest::dataSecurityConfig)).setter(UpdateFlywheelRequest.setter(Builder::dataSecurityConfig)).constructor(UpdateDataSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD, ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DATA_SECURITY_CONFIG_FIELD));
    private final String flywheelArn;
    private final String activeModelArn;
    private final String dataAccessRoleArn;
    private final UpdateDataSecurityConfig dataSecurityConfig;

    private UpdateFlywheelRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.dataSecurityConfig = builder.dataSecurityConfig;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public final String activeModelArn() {
        return this.activeModelArn;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final UpdateDataSecurityConfig dataSecurityConfig() {
        return this.dataSecurityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSecurityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlywheelRequest)) {
            return false;
        }
        UpdateFlywheelRequest other = (UpdateFlywheelRequest)((Object)obj);
        return Objects.equals(this.flywheelArn(), other.flywheelArn()) && Objects.equals(this.activeModelArn(), other.activeModelArn()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.dataSecurityConfig(), other.dataSecurityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlywheelRequest").add("FlywheelArn", (Object)this.flywheelArn()).add("ActiveModelArn", (Object)this.activeModelArn()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("DataSecurityConfig", (Object)this.dataSecurityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
            case "ActiveModelArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelArn()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "DataSecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSecurityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlywheelRequest, T> g) {
        return obj -> g.apply((UpdateFlywheelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String flywheelArn;
        private String activeModelArn;
        private String dataAccessRoleArn;
        private UpdateDataSecurityConfig dataSecurityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlywheelRequest model) {
            super(model);
            this.flywheelArn(model.flywheelArn);
            this.activeModelArn(model.activeModelArn);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.dataSecurityConfig(model.dataSecurityConfig);
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return this.activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final UpdateDataSecurityConfig.Builder getDataSecurityConfig() {
            return this.dataSecurityConfig != null ? this.dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(UpdateDataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(UpdateDataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlywheelRequest build() {
            return new UpdateFlywheelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlywheelRequest> {
        public Builder flywheelArn(String var1);

        public Builder activeModelArn(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder dataSecurityConfig(UpdateDataSecurityConfig var1);

        default public Builder dataSecurityConfig(Consumer<UpdateDataSecurityConfig.Builder> dataSecurityConfig) {
            return this.dataSecurityConfig((UpdateDataSecurityConfig)((UpdateDataSecurityConfig.Builder)UpdateDataSecurityConfig.builder().applyMutation(dataSecurityConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

