/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfPiiEntitiesCopier;
import software.amazon.awssdk.services.comprehend.model.PiiEntity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectPiiEntitiesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectPiiEntitiesResponse> {
    private static final SdkField<List<PiiEntity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(DetectPiiEntitiesResponse.getter(DetectPiiEntitiesResponse::entities)).setter(DetectPiiEntitiesResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PiiEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD));
    private final List<PiiEntity> entities;

    private DetectPiiEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<PiiEntity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectPiiEntitiesResponse)) {
            return false;
        }
        DetectPiiEntitiesResponse other = (DetectPiiEntitiesResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"DetectPiiEntitiesResponse").add("Entities", this.hasEntities() ? this.entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectPiiEntitiesResponse, T> g) {
        return obj -> g.apply((DetectPiiEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<PiiEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectPiiEntitiesResponse model) {
            super(model);
            this.entities(model.entities);
        }

        public final List<PiiEntity.Builder> getEntities() {
            List<PiiEntity.Builder> result = ListOfPiiEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<PiiEntity.BuilderImpl> entities) {
            this.entities = ListOfPiiEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<PiiEntity> entities) {
            this.entities = ListOfPiiEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(PiiEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<PiiEntity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (PiiEntity)((PiiEntity.Builder)PiiEntity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectPiiEntitiesResponse build() {
            return new DetectPiiEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectPiiEntitiesResponse> {
        public Builder entities(Collection<PiiEntity> var1);

        public Builder entities(PiiEntity ... var1);

        public Builder entities(Consumer<PiiEntity.Builder> ... var1);
    }
}

