/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.AttributeNamesListCopier;
import software.amazon.awssdk.services.comprehend.model.AugmentedManifestsDocumentTypeFormat;
import software.amazon.awssdk.services.comprehend.model.Split;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AugmentedManifestsListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AugmentedManifestsListItem> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::s3Uri)).setter(AugmentedManifestsListItem.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> SPLIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Split").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::splitAsString)).setter(AugmentedManifestsListItem.setter(Builder::split)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Split").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::attributeNames)).setter(AugmentedManifestsListItem.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ANNOTATION_DATA_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnnotationDataS3Uri").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::annotationDataS3Uri)).setter(AugmentedManifestsListItem.setter(Builder::annotationDataS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationDataS3Uri").build()}).build();
    private static final SdkField<String> SOURCE_DOCUMENTS_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDocumentsS3Uri").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::sourceDocumentsS3Uri)).setter(AugmentedManifestsListItem.setter(Builder::sourceDocumentsS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDocumentsS3Uri").build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentType").getter(AugmentedManifestsListItem.getter(AugmentedManifestsListItem::documentTypeAsString)).setter(AugmentedManifestsListItem.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, SPLIT_FIELD, ATTRIBUTE_NAMES_FIELD, ANNOTATION_DATA_S3_URI_FIELD, SOURCE_DOCUMENTS_S3_URI_FIELD, DOCUMENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String split;
    private final List<String> attributeNames;
    private final String annotationDataS3Uri;
    private final String sourceDocumentsS3Uri;
    private final String documentType;

    private AugmentedManifestsListItem(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.split = builder.split;
        this.attributeNames = builder.attributeNames;
        this.annotationDataS3Uri = builder.annotationDataS3Uri;
        this.sourceDocumentsS3Uri = builder.sourceDocumentsS3Uri;
        this.documentType = builder.documentType;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final Split split() {
        return Split.fromValue(this.split);
    }

    public final String splitAsString() {
        return this.split;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public final String annotationDataS3Uri() {
        return this.annotationDataS3Uri;
    }

    public final String sourceDocumentsS3Uri() {
        return this.sourceDocumentsS3Uri;
    }

    public final AugmentedManifestsDocumentTypeFormat documentType() {
        return AugmentedManifestsDocumentTypeFormat.fromValue(this.documentType);
    }

    public final String documentTypeAsString() {
        return this.documentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.splitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationDataS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDocumentsS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AugmentedManifestsListItem)) {
            return false;
        }
        AugmentedManifestsListItem other = (AugmentedManifestsListItem)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.splitAsString(), other.splitAsString()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames()) && Objects.equals(this.annotationDataS3Uri(), other.annotationDataS3Uri()) && Objects.equals(this.sourceDocumentsS3Uri(), other.sourceDocumentsS3Uri()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AugmentedManifestsListItem").add("S3Uri", (Object)this.s3Uri()).add("Split", (Object)this.splitAsString()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).add("AnnotationDataS3Uri", (Object)this.annotationDataS3Uri()).add("SourceDocumentsS3Uri", (Object)this.sourceDocumentsS3Uri()).add("DocumentType", (Object)this.documentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "Split": {
                return Optional.ofNullable(clazz.cast(this.splitAsString()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
            case "AnnotationDataS3Uri": {
                return Optional.ofNullable(clazz.cast(this.annotationDataS3Uri()));
            }
            case "SourceDocumentsS3Uri": {
                return Optional.ofNullable(clazz.cast(this.sourceDocumentsS3Uri()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AugmentedManifestsListItem, T> g) {
        return obj -> g.apply((AugmentedManifestsListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String split;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();
        private String annotationDataS3Uri;
        private String sourceDocumentsS3Uri;
        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AugmentedManifestsListItem model) {
            this.s3Uri(model.s3Uri);
            this.split(model.split);
            this.attributeNames(model.attributeNames);
            this.annotationDataS3Uri(model.annotationDataS3Uri);
            this.sourceDocumentsS3Uri(model.sourceDocumentsS3Uri);
            this.documentType(model.documentType);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        @Transient
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getSplit() {
            return this.split;
        }

        public final void setSplit(String split) {
            this.split = split;
        }

        @Override
        @Transient
        public final Builder split(String split) {
            this.split = split;
            return this;
        }

        @Override
        @Transient
        public final Builder split(Split split) {
            this.split(split == null ? null : split.toString());
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
        }

        @Override
        @Transient
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final String getAnnotationDataS3Uri() {
            return this.annotationDataS3Uri;
        }

        public final void setAnnotationDataS3Uri(String annotationDataS3Uri) {
            this.annotationDataS3Uri = annotationDataS3Uri;
        }

        @Override
        @Transient
        public final Builder annotationDataS3Uri(String annotationDataS3Uri) {
            this.annotationDataS3Uri = annotationDataS3Uri;
            return this;
        }

        public final String getSourceDocumentsS3Uri() {
            return this.sourceDocumentsS3Uri;
        }

        public final void setSourceDocumentsS3Uri(String sourceDocumentsS3Uri) {
            this.sourceDocumentsS3Uri = sourceDocumentsS3Uri;
        }

        @Override
        @Transient
        public final Builder sourceDocumentsS3Uri(String sourceDocumentsS3Uri) {
            this.sourceDocumentsS3Uri = sourceDocumentsS3Uri;
            return this;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        @Transient
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        @Transient
        public final Builder documentType(AugmentedManifestsDocumentTypeFormat documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public AugmentedManifestsListItem build() {
            return new AugmentedManifestsListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AugmentedManifestsListItem> {
        public Builder s3Uri(String var1);

        public Builder split(String var1);

        public Builder split(Split var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder annotationDataS3Uri(String var1);

        public Builder sourceDocumentsS3Uri(String var1);

        public Builder documentType(String var1);

        public Builder documentType(AugmentedManifestsDocumentTypeFormat var1);
    }
}

