/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;

public class ListKeyPhrasesDetectionJobsIterable
implements SdkIterable<ListKeyPhrasesDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListKeyPhrasesDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyPhrasesDetectionJobsIterable(ComprehendClient client, ListKeyPhrasesDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeyPhrasesDetectionJobsResponseFetcher();
    }

    public Iterator<ListKeyPhrasesDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKeyPhrasesDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListKeyPhrasesDetectionJobsResponse> {
        private ListKeyPhrasesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyPhrasesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKeyPhrasesDetectionJobsResponse nextPage(ListKeyPhrasesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListKeyPhrasesDetectionJobsIterable.this.client.listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsIterable.this.firstRequest);
            }
            return ListKeyPhrasesDetectionJobsIterable.this.client.listKeyPhrasesDetectionJobs((ListKeyPhrasesDetectionJobsRequest)((Object)ListKeyPhrasesDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

