/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;

public class ListDocumentClassifierSummariesIterable
implements SdkIterable<ListDocumentClassifierSummariesResponse> {
    private final ComprehendClient client;
    private final ListDocumentClassifierSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDocumentClassifierSummariesIterable(ComprehendClient client, ListDocumentClassifierSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDocumentClassifierSummariesResponseFetcher();
    }

    public Iterator<ListDocumentClassifierSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDocumentClassifierSummariesResponseFetcher
    implements SyncPageFetcher<ListDocumentClassifierSummariesResponse> {
        private ListDocumentClassifierSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassifierSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDocumentClassifierSummariesResponse nextPage(ListDocumentClassifierSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassifierSummariesIterable.this.client.listDocumentClassifierSummaries(ListDocumentClassifierSummariesIterable.this.firstRequest);
            }
            return ListDocumentClassifierSummariesIterable.this.client.listDocumentClassifierSummaries((ListDocumentClassifierSummariesRequest)((Object)ListDocumentClassifierSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

