/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyntaxToken
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyntaxToken> {
    private static final SdkField<Integer> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TokenId").getter(SyntaxToken.getter(SyntaxToken::tokenId)).setter(SyntaxToken.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SyntaxToken.getter(SyntaxToken::text)).setter(SyntaxToken.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(SyntaxToken.getter(SyntaxToken::beginOffset)).setter(SyntaxToken.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(SyntaxToken.getter(SyntaxToken::endOffset)).setter(SyntaxToken.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final SdkField<PartOfSpeechTag> PART_OF_SPEECH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PartOfSpeech").getter(SyntaxToken.getter(SyntaxToken::partOfSpeech)).setter(SyntaxToken.setter(Builder::partOfSpeech)).constructor(PartOfSpeechTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartOfSpeech").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD, TEXT_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD, PART_OF_SPEECH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer tokenId;
    private final String text;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final PartOfSpeechTag partOfSpeech;

    private SyntaxToken(BuilderImpl builder) {
        this.tokenId = builder.tokenId;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.partOfSpeech = builder.partOfSpeech;
    }

    public final Integer tokenId() {
        return this.tokenId;
    }

    public final String text() {
        return this.text;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public final PartOfSpeechTag partOfSpeech() {
        return this.partOfSpeech;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.partOfSpeech());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntaxToken)) {
            return false;
        }
        SyntaxToken other = (SyntaxToken)obj;
        return Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.partOfSpeech(), other.partOfSpeech());
    }

    public final String toString() {
        return ToString.builder((String)"SyntaxToken").add("TokenId", (Object)this.tokenId()).add("Text", (Object)this.text()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("PartOfSpeech", (Object)this.partOfSpeech()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "PartOfSpeech": {
                return Optional.ofNullable(clazz.cast(this.partOfSpeech()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyntaxToken, T> g) {
        return obj -> g.apply((SyntaxToken)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer tokenId;
        private String text;
        private Integer beginOffset;
        private Integer endOffset;
        private PartOfSpeechTag partOfSpeech;

        private BuilderImpl() {
        }

        private BuilderImpl(SyntaxToken model) {
            this.tokenId(model.tokenId);
            this.text(model.text);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.partOfSpeech(model.partOfSpeech);
        }

        public final Integer getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(Integer tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(Integer tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final PartOfSpeechTag.Builder getPartOfSpeech() {
            return this.partOfSpeech != null ? this.partOfSpeech.toBuilder() : null;
        }

        public final void setPartOfSpeech(PartOfSpeechTag.BuilderImpl partOfSpeech) {
            this.partOfSpeech = partOfSpeech != null ? partOfSpeech.build() : null;
        }

        @Override
        public final Builder partOfSpeech(PartOfSpeechTag partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return this;
        }

        public SyntaxToken build() {
            return new SyntaxToken(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyntaxToken> {
        public Builder tokenId(Integer var1);

        public Builder text(String var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder partOfSpeech(PartOfSpeechTag var1);

        default public Builder partOfSpeech(Consumer<PartOfSpeechTag.Builder> partOfSpeech) {
            return this.partOfSpeech((PartOfSpeechTag)((PartOfSpeechTag.Builder)PartOfSpeechTag.builder().applyMutation(partOfSpeech)).build());
        }
    }
}

