/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DocumentClassifierDataFormat {
    COMPREHEND_CSV("COMPREHEND_CSV"),
    AUGMENTED_MANIFEST("AUGMENTED_MANIFEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DocumentClassifierDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentClassifierDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DocumentClassifierDataFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentClassifierDataFormat> knownValues() {
        return Stream.of(DocumentClassifierDataFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

