/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DominantLanguage;
import software.amazon.awssdk.services.comprehend.model.ListOfDominantLanguagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectDominantLanguageResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectDominantLanguageResponse> {
    private static final SdkField<List<DominantLanguage>> LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Languages").getter(DetectDominantLanguageResponse.getter(DetectDominantLanguageResponse::languages)).setter(DetectDominantLanguageResponse.setter(Builder::languages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DominantLanguage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGES_FIELD));
    private final List<DominantLanguage> languages;

    private DetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
    }

    public final boolean hasLanguages() {
        return this.languages != null && !(this.languages instanceof SdkAutoConstructList);
    }

    public final List<DominantLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguages() ? this.languages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectDominantLanguageResponse)) {
            return false;
        }
        DetectDominantLanguageResponse other = (DetectDominantLanguageResponse)((Object)obj);
        return this.hasLanguages() == other.hasLanguages() && Objects.equals(this.languages(), other.languages());
    }

    public final String toString() {
        return ToString.builder((String)"DetectDominantLanguageResponse").add("Languages", this.hasLanguages() ? this.languages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Languages": {
                return Optional.ofNullable(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectDominantLanguageResponse, T> g) {
        return obj -> g.apply((DetectDominantLanguageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DominantLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectDominantLanguageResponse model) {
            super(model);
            this.languages(model.languages);
        }

        public final List<DominantLanguage.Builder> getLanguages() {
            List<DominantLanguage.Builder> result = ListOfDominantLanguagesCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        @Override
        @Transient
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder languages(DominantLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder> ... languages) {
            this.languages(Stream.of(languages).map(c -> (DominantLanguage)((DominantLanguage.Builder)DominantLanguage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectDominantLanguageResponse build() {
            return new DetectDominantLanguageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectDominantLanguageResponse> {
        public Builder languages(Collection<DominantLanguage> var1);

        public Builder languages(DominantLanguage ... var1);

        public Builder languages(Consumer<DominantLanguage.Builder> ... var1);
    }
}

