/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntitiesDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.EntitiesDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEntitiesDetectionJobsResponse> {
    private static final SdkField<List<EntitiesDetectionJobProperties>> ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitiesDetectionJobPropertiesList").getter(ListEntitiesDetectionJobsResponse.getter(ListEntitiesDetectionJobsResponse::entitiesDetectionJobPropertiesList)).setter(ListEntitiesDetectionJobsResponse.setter(Builder::entitiesDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitiesDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitiesDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntitiesDetectionJobsResponse.getter(ListEntitiesDetectionJobsResponse::nextToken)).setter(ListEntitiesDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList;
    private final String nextToken;

    private ListEntitiesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.entitiesDetectionJobPropertiesList = builder.entitiesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntitiesDetectionJobPropertiesList() {
        return this.entitiesDetectionJobPropertiesList != null && !(this.entitiesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList() {
        return this.entitiesDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitiesDetectionJobPropertiesList() ? this.entitiesDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesDetectionJobsResponse)) {
            return false;
        }
        ListEntitiesDetectionJobsResponse other = (ListEntitiesDetectionJobsResponse)((Object)obj);
        return this.hasEntitiesDetectionJobPropertiesList() == other.hasEntitiesDetectionJobPropertiesList() && Objects.equals(this.entitiesDetectionJobPropertiesList(), other.entitiesDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesDetectionJobsResponse").add("EntitiesDetectionJobPropertiesList", this.hasEntitiesDetectionJobPropertiesList() ? this.entitiesDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitiesDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.entitiesDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListEntitiesDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesDetectionJobsResponse model) {
            super(model);
            this.entitiesDetectionJobPropertiesList(model.entitiesDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<EntitiesDetectionJobProperties.Builder> getEntitiesDetectionJobPropertiesList() {
            List<EntitiesDetectionJobProperties.Builder> result = EntitiesDetectionJobPropertiesListCopier.copyToBuilder(this.entitiesDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties.BuilderImpl> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier.copyFromBuilder(entitiesDetectionJobPropertiesList);
        }

        @Override
        @Transient
        public final Builder entitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier.copy(entitiesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(EntitiesDetectionJobProperties ... entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList(Arrays.asList(entitiesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(Consumer<EntitiesDetectionJobProperties.Builder> ... entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList(Stream.of(entitiesDetectionJobPropertiesList).map(c -> (EntitiesDetectionJobProperties)((EntitiesDetectionJobProperties.Builder)EntitiesDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntitiesDetectionJobsResponse build() {
            return new ListEntitiesDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesDetectionJobsResponse> {
        public Builder entitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties> var1);

        public Builder entitiesDetectionJobPropertiesList(EntitiesDetectionJobProperties ... var1);

        public Builder entitiesDetectionJobPropertiesList(Consumer<EntitiesDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

