/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifierSummariesIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizerSummariesIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ClassifyDocumentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ContainsPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribePiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifierSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizerSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEventsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListPiiEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultComprehendClient
implements ComprehendClient {
    private static final Logger log = Logger.loggerFor(DefaultComprehendClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "comprehend";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectDominantLanguageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, batchDetectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectDominantLanguage");
            BatchDetectDominantLanguageResponse batchDetectDominantLanguageResponse = (BatchDetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectDominantLanguage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectDominantLanguageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectDominantLanguageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectDominantLanguage$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, batchDetectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectEntities");
            BatchDetectEntitiesResponse batchDetectEntitiesResponse = (BatchDetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectEntities$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectKeyPhrasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, batchDetectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectKeyPhrases");
            BatchDetectKeyPhrasesResponse batchDetectKeyPhrasesResponse = (BatchDetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectKeyPhrases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectKeyPhrasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectKeyPhrasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectKeyPhrases$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSentimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, batchDetectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSentiment");
            BatchDetectSentimentResponse batchDetectSentimentResponse = (BatchDetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSentiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectSentiment$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectSyntaxResponse batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSyntaxResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, batchDetectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSyntax");
            BatchDetectSyntaxResponse batchDetectSyntaxResponse = (BatchDetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSyntax").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSyntaxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectSyntaxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectSyntax$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassifyDocumentResponse classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClassifyDocumentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, classifyDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClassifyDocument");
            ClassifyDocumentResponse classifyDocumentResponse = (ClassifyDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClassifyDocument").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)classifyDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ClassifyDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return classifyDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$classifyDocument$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainsPiiEntitiesResponse containsPiiEntities(ContainsPiiEntitiesRequest containsPiiEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ContainsPiiEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, containsPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ContainsPiiEntities");
            ContainsPiiEntitiesResponse containsPiiEntitiesResponse = (ContainsPiiEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ContainsPiiEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)containsPiiEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ContainsPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return containsPiiEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$containsPiiEntities$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDocumentClassifierResponse createDocumentClassifier(CreateDocumentClassifierRequest createDocumentClassifierRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, createDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDocumentClassifier");
            CreateDocumentClassifierResponse createDocumentClassifierResponse = (CreateDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createDocumentClassifier$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws InvalidRequestException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException, TooManyRequestsException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, createEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpoint");
            CreateEndpointResponse createEndpointResponse = (CreateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createEndpoint$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEntityRecognizerResponse createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, createEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEntityRecognizer");
            CreateEntityRecognizerResponse createEntityRecognizerResponse = (CreateEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createEntityRecognizer$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentClassifierResponse deleteDocumentClassifier(DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, deleteDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocumentClassifier");
            DeleteDocumentClassifierResponse deleteDocumentClassifierResponse = (DeleteDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteDocumentClassifier$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            DeleteEndpointResponse deleteEndpointResponse = (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteEndpoint$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEntityRecognizerResponse deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, deleteEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEntityRecognizer");
            DeleteEntityRecognizerResponse deleteEntityRecognizerResponse = (DeleteEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteEntityRecognizer$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassificationJob");
            DescribeDocumentClassificationJobResponse describeDocumentClassificationJobResponse = (DescribeDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDocumentClassificationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDocumentClassificationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDocumentClassificationJob$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentClassifierResponse describeDocumentClassifier(DescribeDocumentClassifierRequest describeDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassifier");
            DescribeDocumentClassifierResponse describeDocumentClassifierResponse = (DescribeDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDocumentClassifier$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDominantLanguageDetectionJob");
            DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJobResponse = (DescribeDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDominantLanguageDetectionJob$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoint");
            DescribeEndpointResponse describeEndpointResponse = (DescribeEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEndpoint$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntitiesDetectionJob");
            DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJobResponse = (DescribeEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEntitiesDetectionJob$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEntityRecognizerResponse describeEntityRecognizer(DescribeEntityRecognizerRequest describeEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntityRecognizer");
            DescribeEntityRecognizerResponse describeEntityRecognizerResponse = (DescribeEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEntityRecognizer$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsDetectionJobResponse describeEventsDetectionJob(DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventsDetectionJob");
            DescribeEventsDetectionJobResponse describeEventsDetectionJobResponse = (DescribeEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEventsDetectionJob$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKeyPhrasesDetectionJob");
            DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJobResponse = (DescribeKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeKeyPhrasesDetectionJob$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePiiEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describePiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePiiEntitiesDetectionJob");
            DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJobResponse = (DescribePiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePiiEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describePiiEntitiesDetectionJob$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSentimentDetectionJob");
            DescribeSentimentDetectionJobResponse describeSentimentDetectionJobResponse = (DescribeSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeSentimentDetectionJob$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTopicsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, describeTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTopicsDetectionJob");
            DescribeTopicsDetectionJobResponse describeTopicsDetectionJobResponse = (DescribeTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTopicsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTopicsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTopicsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeTopicsDetectionJob$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDominantLanguageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectDominantLanguage");
            DetectDominantLanguageResponse detectDominantLanguageResponse = (DetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDominantLanguage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectDominantLanguageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectDominantLanguageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectDominantLanguage$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectEntities");
            DetectEntitiesResponse detectEntitiesResponse = (DetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectEntities$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectKeyPhrasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectKeyPhrases");
            DetectKeyPhrasesResponse detectKeyPhrasesResponse = (DetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectKeyPhrases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectKeyPhrasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectKeyPhrasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectKeyPhrases$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectPiiEntitiesResponse detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectPiiEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectPiiEntities");
            DetectPiiEntitiesResponse detectPiiEntitiesResponse = (DetectPiiEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectPiiEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectPiiEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectPiiEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectPiiEntities$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSentimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSentiment");
            DetectSentimentResponse detectSentimentResponse = (DetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSentiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectSentiment$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectSyntaxResponse detectSyntax(DetectSyntaxRequest detectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSyntaxResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, detectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSyntax");
            DetectSyntaxResponse detectSyntaxResponse = (DetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSyntax").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSyntaxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectSyntaxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectSyntax$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassificationJobsResponse listDocumentClassificationJobs(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassificationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listDocumentClassificationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassificationJobs");
            ListDocumentClassificationJobsResponse listDocumentClassificationJobsResponse = (ListDocumentClassificationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassificationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDocumentClassificationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassificationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassificationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassificationJobs$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassificationJobsIterable(this, this.applyPaginatorUserAgent(listDocumentClassificationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassifierSummariesResponse listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifierSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listDocumentClassifierSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifierSummaries");
            ListDocumentClassifierSummariesResponse listDocumentClassifierSummariesResponse = (ListDocumentClassifierSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifierSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDocumentClassifierSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassifierSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassifierSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassifierSummaries$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDocumentClassifierSummariesIterable listDocumentClassifierSummariesPaginator(ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassifierSummariesIterable(this, this.applyPaginatorUserAgent(listDocumentClassifierSummariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassifiersResponse listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifiersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listDocumentClassifiersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifiers");
            ListDocumentClassifiersResponse listDocumentClassifiersResponse = (ListDocumentClassifiersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifiers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDocumentClassifiersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassifiersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassifiers$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDocumentClassifiersIterable listDocumentClassifiersPaginator(ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassifiersIterable(this, this.applyPaginatorUserAgent(listDocumentClassifiersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listDominantLanguageDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDominantLanguageDetectionJobs");
            ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobsResponse = (ListDominantLanguageDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDominantLanguageDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDominantLanguageDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDominantLanguageDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDominantLanguageDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDominantLanguageDetectionJobs$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDominantLanguageDetectionJobsIterable(this, this.applyPaginatorUserAgent(listDominantLanguageDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpoints");
            ListEndpointsResponse listEndpointsResponse = (ListEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEndpoints$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitiesDetectionJobs");
            ListEntitiesDetectionJobsResponse listEntitiesDetectionJobsResponse = (ListEntitiesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitiesDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntitiesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntitiesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntitiesDetectionJobs$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntitiesDetectionJobsIterable(this, this.applyPaginatorUserAgent(listEntitiesDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntityRecognizerSummariesResponse listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizerSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listEntityRecognizerSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizerSummaries");
            ListEntityRecognizerSummariesResponse listEntityRecognizerSummariesResponse = (ListEntityRecognizerSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizerSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntityRecognizerSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntityRecognizerSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntityRecognizerSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntityRecognizerSummaries$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEntityRecognizerSummariesIterable listEntityRecognizerSummariesPaginator(ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntityRecognizerSummariesIterable(this, this.applyPaginatorUserAgent(listEntityRecognizerSummariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntityRecognizersResponse listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listEntityRecognizersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizers");
            ListEntityRecognizersResponse listEntityRecognizersResponse = (ListEntityRecognizersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntityRecognizersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntityRecognizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntityRecognizersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntityRecognizers$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEntityRecognizersIterable listEntityRecognizersPaginator(ListEntityRecognizersRequest listEntityRecognizersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntityRecognizersIterable(this, this.applyPaginatorUserAgent(listEntityRecognizersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventsDetectionJobsResponse listEventsDetectionJobs(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventsDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listEventsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventsDetectionJobs");
            ListEventsDetectionJobsResponse listEventsDetectionJobsResponse = (ListEventsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventsDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEventsDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventsDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEventsDetectionJobs$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEventsDetectionJobsIterable listEventsDetectionJobsPaginator(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEventsDetectionJobsIterable(this, this.applyPaginatorUserAgent(listEventsDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listKeyPhrasesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPhrasesDetectionJobs");
            ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobsResponse = (ListKeyPhrasesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPhrasesDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeyPhrasesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyPhrasesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyPhrasesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listKeyPhrasesDetectionJobs$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListKeyPhrasesDetectionJobsIterable(this, this.applyPaginatorUserAgent(listKeyPhrasesDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPiiEntitiesDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listPiiEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPiiEntitiesDetectionJobs");
            ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobsResponse = (ListPiiEntitiesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPiiEntitiesDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPiiEntitiesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPiiEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPiiEntitiesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listPiiEntitiesDetectionJobs$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSentimentDetectionJobsResponse listSentimentDetectionJobs(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSentimentDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSentimentDetectionJobs");
            ListSentimentDetectionJobsResponse listSentimentDetectionJobsResponse = (ListSentimentDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSentimentDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSentimentDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSentimentDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listSentimentDetectionJobs$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListSentimentDetectionJobsIterable(this, this.applyPaginatorUserAgent(listSentimentDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listTagsForResource$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTopicsDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, listTopicsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTopicsDetectionJobs");
            ListTopicsDetectionJobsResponse listTopicsDetectionJobsResponse = (ListTopicsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopicsDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTopicsDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listTopicsDetectionJobs$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListTopicsDetectionJobsIterable(this, this.applyPaginatorUserAgent(listTopicsDetectionJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentClassificationJobResponse startDocumentClassificationJob(StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentClassificationJob");
            StartDocumentClassificationJobResponse startDocumentClassificationJobResponse = (StartDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDocumentClassificationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentClassificationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startDocumentClassificationJob$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDominantLanguageDetectionJob");
            StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJobResponse = (StartDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startDominantLanguageDetectionJob$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEntitiesDetectionJobResponse startEntitiesDetectionJob(StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEntitiesDetectionJob");
            StartEntitiesDetectionJobResponse startEntitiesDetectionJobResponse = (StartEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startEntitiesDetectionJob$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEventsDetectionJobResponse startEventsDetectionJob(StartEventsDetectionJobRequest startEventsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEventsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEventsDetectionJob");
            StartEventsDetectionJobResponse startEventsDetectionJobResponse = (StartEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEventsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startEventsDetectionJob$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartKeyPhrasesDetectionJob");
            StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJobResponse = (StartKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startKeyPhrasesDetectionJob$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPiiEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPiiEntitiesDetectionJob");
            StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJobResponse = (StartPiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPiiEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startPiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startPiiEntitiesDetectionJob$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSentimentDetectionJobResponse startSentimentDetectionJob(StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSentimentDetectionJob");
            StartSentimentDetectionJobResponse startSentimentDetectionJobResponse = (StartSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startSentimentDetectionJob$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTopicsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, startTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTopicsDetectionJob");
            StartTopicsDetectionJobResponse startTopicsDetectionJobResponse = (StartTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTopicsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTopicsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTopicsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startTopicsDetectionJob$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDominantLanguageDetectionJob");
            StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJobResponse = (StopDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopDominantLanguageDetectionJob$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEntitiesDetectionJob");
            StopEntitiesDetectionJobResponse stopEntitiesDetectionJobResponse = (StopEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopEntitiesDetectionJob$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEventsDetectionJobResponse stopEventsDetectionJob(StopEventsDetectionJobRequest stopEventsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEventsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEventsDetectionJob");
            StopEventsDetectionJobResponse stopEventsDetectionJobResponse = (StopEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEventsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopEventsDetectionJob$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopKeyPhrasesDetectionJob");
            StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJobResponse = (StopKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopKeyPhrasesDetectionJob$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPiiEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPiiEntitiesDetectionJob");
            StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJobResponse = (StopPiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPiiEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopPiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopPiiEntitiesDetectionJob$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopSentimentDetectionJobResponse stopSentimentDetectionJob(StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSentimentDetectionJob");
            StopSentimentDetectionJobResponse stopSentimentDetectionJobResponse = (StopSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopSentimentDetectionJob$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopTrainingDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingDocumentClassifier");
            StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifierResponse = (StopTrainingDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopTrainingDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTrainingDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTrainingDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopTrainingDocumentClassifier$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, stopTrainingEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingEntityRecognizer");
            StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizerResponse = (StopTrainingEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopTrainingEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTrainingEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTrainingEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopTrainingEntityRecognizer$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$tagResource$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyTagKeysException, InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$untagResource$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(this.clientConfiguration, updateEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpoint");
            UpdateEndpointResponse updateEndpointResponse = (UpdateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$updateEndpoint$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComprehendException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").exceptionBuilderSupplier(KmsKeyValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFilterException").exceptionBuilderSupplier(InvalidFilterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").exceptionBuilderSupplier(TooManyTagKeysException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").exceptionBuilderSupplier(UnsupportedLanguageException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobNotFoundException").exceptionBuilderSupplier(JobNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ComprehendRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.102").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ComprehendRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateEndpoint$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingEntityRecognizer$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingDocumentClassifier$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSentimentDetectionJob$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPiiEntitiesDetectionJob$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopKeyPhrasesDetectionJob$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEventsDetectionJob$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEntitiesDetectionJob$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDominantLanguageDetectionJob$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTopicsDetectionJob$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSentimentDetectionJob$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPiiEntitiesDetectionJob$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startKeyPhrasesDetectionJob$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEventsDetectionJob$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEntitiesDetectionJob$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDominantLanguageDetectionJob$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentClassificationJob$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTopicsDetectionJobs$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSentimentDetectionJobs$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPiiEntitiesDetectionJobs$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyPhrasesDetectionJobs$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventsDetectionJobs$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizers$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizerSummaries$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitiesDetectionJobs$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpoints$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDominantLanguageDetectionJobs$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifiers$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifierSummaries$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassificationJobs$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSyntax$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSentiment$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectPiiEntities$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectKeyPhrases$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectEntities$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectDominantLanguage$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTopicsDetectionJob$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSentimentDetectionJob$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePiiEntitiesDetectionJob$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKeyPhrasesDetectionJob$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventsDetectionJob$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntityRecognizer$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntitiesDetectionJob$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoint$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDominantLanguageDetectionJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassifier$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassificationJob$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEntityRecognizer$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocumentClassifier$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEntityRecognizer$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpoint$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDocumentClassifier$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$containsPiiEntities$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$classifyDocument$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSyntax$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSentiment$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectKeyPhrases$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectEntities$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectDominantLanguage$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

