/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.services.comprehend.model.BatchItemErrorListCopier;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfDetectSentimentResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectSentimentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, BatchDetectSentimentResponse> {
    private static final SdkField<List<BatchDetectSentimentItemResult>> RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultList").getter(BatchDetectSentimentResponse.getter(BatchDetectSentimentResponse::resultList)).setter(BatchDetectSentimentResponse.setter(Builder::resultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDetectSentimentItemResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorList").getter(BatchDetectSentimentResponse.getter(BatchDetectSentimentResponse::errorList)).setter(BatchDetectSentimentResponse.setter(Builder::errorList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD, ERROR_LIST_FIELD));
    private final List<BatchDetectSentimentItemResult> resultList;
    private final List<BatchItemError> errorList;

    private BatchDetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    public final boolean hasResultList() {
        return this.resultList != null && !(this.resultList instanceof SdkAutoConstructList);
    }

    public final List<BatchDetectSentimentItemResult> resultList() {
        return this.resultList;
    }

    public final boolean hasErrorList() {
        return this.errorList != null && !(this.errorList instanceof SdkAutoConstructList);
    }

    public final List<BatchItemError> errorList() {
        return this.errorList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultList() ? this.resultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorList() ? this.errorList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentResponse)) {
            return false;
        }
        BatchDetectSentimentResponse other = (BatchDetectSentimentResponse)((Object)obj);
        return this.hasResultList() == other.hasResultList() && Objects.equals(this.resultList(), other.resultList()) && this.hasErrorList() == other.hasErrorList() && Objects.equals(this.errorList(), other.errorList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetectSentimentResponse").add("ResultList", this.hasResultList() ? this.resultList() : null).add("ErrorList", this.hasErrorList() ? this.errorList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.ofNullable(clazz.cast(this.resultList()));
            }
            case "ErrorList": {
                return Optional.ofNullable(clazz.cast(this.errorList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSentimentResponse, T> g) {
        return obj -> g.apply((BatchDetectSentimentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<BatchDetectSentimentItemResult> resultList = DefaultSdkAutoConstructList.getInstance();
        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentResponse model) {
            super(model);
            this.resultList(model.resultList);
            this.errorList(model.errorList);
        }

        public final Collection<BatchDetectSentimentItemResult.Builder> getResultList() {
            if (this.resultList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultList != null ? (Collection)this.resultList.stream().map(BatchDetectSentimentItemResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectSentimentItemResult> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectSentimentItemResult ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectSentimentItemResult.Builder> ... resultList) {
            this.resultList(Stream.of(resultList).map(c -> (BatchDetectSentimentItemResult)((BatchDetectSentimentItemResult.Builder)BatchDetectSentimentItemResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResultList(Collection<BatchDetectSentimentItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            if (this.errorList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorList != null ? (Collection)this.errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError ... errorList) {
            this.errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder> ... errorList) {
            this.errorList(Stream.of(errorList).map(c -> (BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectSentimentResponse build() {
            return new BatchDetectSentimentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDetectSentimentResponse> {
        public Builder resultList(Collection<BatchDetectSentimentItemResult> var1);

        public Builder resultList(BatchDetectSentimentItemResult ... var1);

        public Builder resultList(Consumer<BatchDetectSentimentItemResult.Builder> ... var1);

        public Builder errorList(Collection<BatchItemError> var1);

        public Builder errorList(BatchItemError ... var1);

        public Builder errorList(Consumer<BatchItemError.Builder> ... var1);
    }
}

