/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDominantLanguageDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDominantLanguageDetectionJobsResponse> {
    private static final SdkField<List<DominantLanguageDetectionJobProperties>> DOMINANT_LANGUAGE_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DominantLanguageDetectionJobPropertiesList").getter(ListDominantLanguageDetectionJobsResponse.getter(ListDominantLanguageDetectionJobsResponse::dominantLanguageDetectionJobPropertiesList)).setter(ListDominantLanguageDetectionJobsResponse.setter(Builder::dominantLanguageDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DominantLanguageDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DominantLanguageDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDominantLanguageDetectionJobsResponse.getter(ListDominantLanguageDetectionJobsResponse::nextToken)).setter(ListDominantLanguageDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMINANT_LANGUAGE_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList;
    private final String nextToken;

    private ListDominantLanguageDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.dominantLanguageDetectionJobPropertiesList = builder.dominantLanguageDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDominantLanguageDetectionJobPropertiesList() {
        return this.dominantLanguageDetectionJobPropertiesList != null && !(this.dominantLanguageDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList() {
        return this.dominantLanguageDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDominantLanguageDetectionJobPropertiesList() ? this.dominantLanguageDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDominantLanguageDetectionJobsResponse)) {
            return false;
        }
        ListDominantLanguageDetectionJobsResponse other = (ListDominantLanguageDetectionJobsResponse)((Object)obj);
        return this.hasDominantLanguageDetectionJobPropertiesList() == other.hasDominantLanguageDetectionJobPropertiesList() && Objects.equals(this.dominantLanguageDetectionJobPropertiesList(), other.dominantLanguageDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDominantLanguageDetectionJobsResponse").add("DominantLanguageDetectionJobPropertiesList", this.hasDominantLanguageDetectionJobPropertiesList() ? this.dominantLanguageDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DominantLanguageDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.dominantLanguageDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDominantLanguageDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListDominantLanguageDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDominantLanguageDetectionJobsResponse model) {
            super(model);
            this.dominantLanguageDetectionJobPropertiesList(model.dominantLanguageDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<DominantLanguageDetectionJobProperties.Builder> getDominantLanguageDetectionJobPropertiesList() {
            List<DominantLanguageDetectionJobProperties.Builder> result = DominantLanguageDetectionJobPropertiesListCopier.copyToBuilder(this.dominantLanguageDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList = DominantLanguageDetectionJobPropertiesListCopier.copy(dominantLanguageDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantLanguageDetectionJobPropertiesList(DominantLanguageDetectionJobProperties ... dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList(Arrays.asList(dominantLanguageDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantLanguageDetectionJobPropertiesList(Consumer<DominantLanguageDetectionJobProperties.Builder> ... dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList(Stream.of(dominantLanguageDetectionJobPropertiesList).map(c -> (DominantLanguageDetectionJobProperties)((DominantLanguageDetectionJobProperties.Builder)DominantLanguageDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties.BuilderImpl> dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList = DominantLanguageDetectionJobPropertiesListCopier.copyFromBuilder(dominantLanguageDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDominantLanguageDetectionJobsResponse build() {
            return new ListDominantLanguageDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDominantLanguageDetectionJobsResponse> {
        public Builder dominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties> var1);

        public Builder dominantLanguageDetectionJobPropertiesList(DominantLanguageDetectionJobProperties ... var1);

        public Builder dominantLanguageDetectionJobPropertiesList(Consumer<DominantLanguageDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

