/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassifierEvaluationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassifierEvaluationMetrics> {
    private static final SdkField<Double> ACCURACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Accuracy").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::accuracy)).setter(ClassifierEvaluationMetrics.setter(Builder::accuracy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accuracy").build()}).build();
    private static final SdkField<Double> PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Precision").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::precision)).setter(ClassifierEvaluationMetrics.setter(Builder::precision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()}).build();
    private static final SdkField<Double> RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Recall").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::recall)).setter(ClassifierEvaluationMetrics.setter(Builder::recall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recall").build()}).build();
    private static final SdkField<Double> F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("F1Score").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::f1Score)).setter(ClassifierEvaluationMetrics.setter(Builder::f1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("F1Score").build()}).build();
    private static final SdkField<Double> MICRO_PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MicroPrecision").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::microPrecision)).setter(ClassifierEvaluationMetrics.setter(Builder::microPrecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroPrecision").build()}).build();
    private static final SdkField<Double> MICRO_RECALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MicroRecall").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::microRecall)).setter(ClassifierEvaluationMetrics.setter(Builder::microRecall)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroRecall").build()}).build();
    private static final SdkField<Double> MICRO_F1_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MicroF1Score").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::microF1Score)).setter(ClassifierEvaluationMetrics.setter(Builder::microF1Score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicroF1Score").build()}).build();
    private static final SdkField<Double> HAMMING_LOSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("HammingLoss").getter(ClassifierEvaluationMetrics.getter(ClassifierEvaluationMetrics::hammingLoss)).setter(ClassifierEvaluationMetrics.setter(Builder::hammingLoss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HammingLoss").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCURACY_FIELD, PRECISION_FIELD, RECALL_FIELD, F1_SCORE_FIELD, MICRO_PRECISION_FIELD, MICRO_RECALL_FIELD, MICRO_F1_SCORE_FIELD, HAMMING_LOSS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double accuracy;
    private final Double precision;
    private final Double recall;
    private final Double f1Score;
    private final Double microPrecision;
    private final Double microRecall;
    private final Double microF1Score;
    private final Double hammingLoss;

    private ClassifierEvaluationMetrics(BuilderImpl builder) {
        this.accuracy = builder.accuracy;
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.f1Score = builder.f1Score;
        this.microPrecision = builder.microPrecision;
        this.microRecall = builder.microRecall;
        this.microF1Score = builder.microF1Score;
        this.hammingLoss = builder.hammingLoss;
    }

    public final Double accuracy() {
        return this.accuracy;
    }

    public final Double precision() {
        return this.precision;
    }

    public final Double recall() {
        return this.recall;
    }

    public final Double f1Score() {
        return this.f1Score;
    }

    public final Double microPrecision() {
        return this.microPrecision;
    }

    public final Double microRecall() {
        return this.microRecall;
    }

    public final Double microF1Score() {
        return this.microF1Score;
    }

    public final Double hammingLoss() {
        return this.hammingLoss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accuracy());
        hashCode = 31 * hashCode + Objects.hashCode(this.precision());
        hashCode = 31 * hashCode + Objects.hashCode(this.recall());
        hashCode = 31 * hashCode + Objects.hashCode(this.f1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.microPrecision());
        hashCode = 31 * hashCode + Objects.hashCode(this.microRecall());
        hashCode = 31 * hashCode + Objects.hashCode(this.microF1Score());
        hashCode = 31 * hashCode + Objects.hashCode(this.hammingLoss());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifierEvaluationMetrics)) {
            return false;
        }
        ClassifierEvaluationMetrics other = (ClassifierEvaluationMetrics)obj;
        return Objects.equals(this.accuracy(), other.accuracy()) && Objects.equals(this.precision(), other.precision()) && Objects.equals(this.recall(), other.recall()) && Objects.equals(this.f1Score(), other.f1Score()) && Objects.equals(this.microPrecision(), other.microPrecision()) && Objects.equals(this.microRecall(), other.microRecall()) && Objects.equals(this.microF1Score(), other.microF1Score()) && Objects.equals(this.hammingLoss(), other.hammingLoss());
    }

    public final String toString() {
        return ToString.builder((String)"ClassifierEvaluationMetrics").add("Accuracy", (Object)this.accuracy()).add("Precision", (Object)this.precision()).add("Recall", (Object)this.recall()).add("F1Score", (Object)this.f1Score()).add("MicroPrecision", (Object)this.microPrecision()).add("MicroRecall", (Object)this.microRecall()).add("MicroF1Score", (Object)this.microF1Score()).add("HammingLoss", (Object)this.hammingLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accuracy": {
                return Optional.ofNullable(clazz.cast(this.accuracy()));
            }
            case "Precision": {
                return Optional.ofNullable(clazz.cast(this.precision()));
            }
            case "Recall": {
                return Optional.ofNullable(clazz.cast(this.recall()));
            }
            case "F1Score": {
                return Optional.ofNullable(clazz.cast(this.f1Score()));
            }
            case "MicroPrecision": {
                return Optional.ofNullable(clazz.cast(this.microPrecision()));
            }
            case "MicroRecall": {
                return Optional.ofNullable(clazz.cast(this.microRecall()));
            }
            case "MicroF1Score": {
                return Optional.ofNullable(clazz.cast(this.microF1Score()));
            }
            case "HammingLoss": {
                return Optional.ofNullable(clazz.cast(this.hammingLoss()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifierEvaluationMetrics, T> g) {
        return obj -> g.apply((ClassifierEvaluationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double accuracy;
        private Double precision;
        private Double recall;
        private Double f1Score;
        private Double microPrecision;
        private Double microRecall;
        private Double microF1Score;
        private Double hammingLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifierEvaluationMetrics model) {
            this.accuracy(model.accuracy);
            this.precision(model.precision);
            this.recall(model.recall);
            this.f1Score(model.f1Score);
            this.microPrecision(model.microPrecision);
            this.microRecall(model.microRecall);
            this.microF1Score(model.microF1Score);
            this.hammingLoss(model.hammingLoss);
        }

        public final Double getAccuracy() {
            return this.accuracy;
        }

        @Override
        public final Builder accuracy(Double accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public final void setAccuracy(Double accuracy) {
            this.accuracy = accuracy;
        }

        public final Double getPrecision() {
            return this.precision;
        }

        @Override
        public final Builder precision(Double precision) {
            this.precision = precision;
            return this;
        }

        public final void setPrecision(Double precision) {
            this.precision = precision;
        }

        public final Double getRecall() {
            return this.recall;
        }

        @Override
        public final Builder recall(Double recall) {
            this.recall = recall;
            return this;
        }

        public final void setRecall(Double recall) {
            this.recall = recall;
        }

        public final Double getF1Score() {
            return this.f1Score;
        }

        @Override
        public final Builder f1Score(Double f1Score) {
            this.f1Score = f1Score;
            return this;
        }

        public final void setF1Score(Double f1Score) {
            this.f1Score = f1Score;
        }

        public final Double getMicroPrecision() {
            return this.microPrecision;
        }

        @Override
        public final Builder microPrecision(Double microPrecision) {
            this.microPrecision = microPrecision;
            return this;
        }

        public final void setMicroPrecision(Double microPrecision) {
            this.microPrecision = microPrecision;
        }

        public final Double getMicroRecall() {
            return this.microRecall;
        }

        @Override
        public final Builder microRecall(Double microRecall) {
            this.microRecall = microRecall;
            return this;
        }

        public final void setMicroRecall(Double microRecall) {
            this.microRecall = microRecall;
        }

        public final Double getMicroF1Score() {
            return this.microF1Score;
        }

        @Override
        public final Builder microF1Score(Double microF1Score) {
            this.microF1Score = microF1Score;
            return this;
        }

        public final void setMicroF1Score(Double microF1Score) {
            this.microF1Score = microF1Score;
        }

        public final Double getHammingLoss() {
            return this.hammingLoss;
        }

        @Override
        public final Builder hammingLoss(Double hammingLoss) {
            this.hammingLoss = hammingLoss;
            return this;
        }

        public final void setHammingLoss(Double hammingLoss) {
            this.hammingLoss = hammingLoss;
        }

        public ClassifierEvaluationMetrics build() {
            return new ClassifierEvaluationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassifierEvaluationMetrics> {
        public Builder accuracy(Double var1);

        public Builder precision(Double var1);

        public Builder recall(Double var1);

        public Builder f1Score(Double var1);

        public Builder microPrecision(Double var1);

        public Builder microRecall(Double var1);

        public Builder microF1Score(Double var1);

        public Builder hammingLoss(Double var1);
    }
}

