/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for filtering a list of entity recognizers. You can only specify one filtering parameter in a
 * request. For more information, see the operation./&gt;
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerFilter.Builder, EntityRecognizerFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EntityRecognizerFilter::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeBefore").getter(getter(EntityRecognizerFilter::submitTimeBefore))
            .setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmitTimeAfter").getter(getter(EntityRecognizerFilter::submitTimeAfter))
            .setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant submitTimeBefore;

    private final Instant submitTimeAfter;

    private EntityRecognizerFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    /**
     * <p>
     * The status of an entity recognizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an entity recognizer.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an entity recognizer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an entity recognizer.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs
     * submitted before the specified time. Jobs are returned in descending order, newest to oldest.
     * </p>
     * 
     * @return Filters the list of entities based on the time that the list was submitted for processing. Returns only
     *         jobs submitted before the specified time. Jobs are returned in descending order, newest to oldest.
     */
    public final Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs
     * submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
     * </p>
     * 
     * @return Filters the list of entities based on the time that the list was submitted for processing. Returns only
     *         jobs submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
     */
    public final Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerFilter)) {
            return false;
        }
        EntityRecognizerFilter other = (EntityRecognizerFilter) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(submitTimeAfter(), other.submitTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerFilter").add("Status", statusAsString())
                .add("SubmitTimeBefore", submitTimeBefore()).add("SubmitTimeAfter", submitTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubmitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "SubmitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerFilter, T> g) {
        return obj -> g.apply((EntityRecognizerFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerFilter> {
        /**
         * <p>
         * The status of an entity recognizer.
         * </p>
         * 
         * @param status
         *        The status of an entity recognizer.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an entity recognizer.
         * </p>
         * 
         * @param status
         *        The status of an entity recognizer.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs
         * submitted before the specified time. Jobs are returned in descending order, newest to oldest.
         * </p>
         * 
         * @param submitTimeBefore
         *        Filters the list of entities based on the time that the list was submitted for processing. Returns
         *        only jobs submitted before the specified time. Jobs are returned in descending order, newest to
         *        oldest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Filters the list of entities based on the time that the list was submitted for processing. Returns only jobs
         * submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
         * </p>
         * 
         * @param submitTimeAfter
         *        Filters the list of entities based on the time that the list was submitted for processing. Returns
         *        only jobs submitted after the specified time. Jobs are returned in ascending order, oldest to newest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant submitTimeBefore;

        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerFilter model) {
            status(model.status);
            submitTimeBefore(model.submitTimeBefore);
            submitTimeAfter(model.submitTimeAfter);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public EntityRecognizerFilter build() {
            return new EntityRecognizerFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
